/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.tabular.AbstractColumn;
import org.refcodes.tabular.PrintStackTrace;

public class ExceptionColumnImpl
extends AbstractColumn<Throwable>
implements Cloneable {
    private PrintStackTrace _printStackTrace;

    public ExceptionColumnImpl(String aKey) {
        this(aKey, PrintStackTrace.EXPLODED);
    }

    public ExceptionColumnImpl(String aKey, PrintStackTrace aPrintStackTrace) {
        super(aKey, Throwable.class);
        this._printStackTrace = aPrintStackTrace;
    }

    @Override
    public String[] toStorageStrings(Throwable aValue) {
        switch (this._printStackTrace) {
            case COMPACT: {
                return new String[]{ExceptionUtility.toMessage(aValue) + ": " + ExceptionUtility.toStackTrace(aValue)};
            }
            case NONE: {
                return new String[]{ExceptionUtility.toMessage(aValue)};
            }
        }
        return new String[]{ExceptionUtility.toMessage(aValue) + ":\n" + ExceptionUtility.toStackTrace(aValue)};
    }

    @Override
    public synchronized Throwable fromStorageStrings(String[] aStringValues) throws ParseException {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    @Override
    public String toPrintable(Throwable aValue) {
        switch (this._printStackTrace) {
            case COMPACT: {
                return ExceptionUtility.toMessage(aValue) + ": " + ExceptionUtility.toStackTrace(aValue);
            }
            case NONE: {
                return ExceptionUtility.toMessage(aValue);
            }
        }
        return ExceptionUtility.toMessage(aValue) + ":\n" + ExceptionUtility.toStackTrace(aValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

