/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.Delimiter;
import org.refcodes.runtime.PropertyBuilderImpl;
import org.refcodes.textual.Case;
import org.refcodes.textual.CaseStyleBuilder;

public class CaseStyleBuilderImpl
implements CaseStyleBuilder {
    private String _text = null;
    private Case _case = Case.UPPER;

    @Override
    public String getText() {
        return this._text;
    }

    @Override
    public void setText(String aText) {
        this._text = aText;
    }

    @Override
    public CaseStyleBuilder withText(String aText) {
        this.setText(aText);
        return this;
    }

    @Override
    public Case getCase() {
        return this._case;
    }

    @Override
    public void setCase(Case aCase) {
        this._case = aCase;
    }

    @Override
    public String toCamelCase() {
        return this.toCamelCase(this.getText());
    }

    @Override
    public String toSnakeCase() {
        return this.toSnakeCase(this.getText());
    }

    @Override
    public String toPascalCase() {
        return this.toPascalCase(this.getText());
    }

    @Override
    public String toKebabCase() {
        return this.toKebabCase(this.getText());
    }

    @Override
    public String toCamelCase(String aText) {
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        String theText = NormalizeCaseUtility.toNormalized(aText, Delimiter.SNAKE_CASE.getChar()).replaceAll("_\u00e4", "\u00c4").replaceAll("_\u00f6", "\u00d6").replaceAll("_\u00fc", "\u00dc").replaceAll("_a", "A").replaceAll("_b", "B").replaceAll("_c", "C").replaceAll("_d", "D").replaceAll("_e", "E").replaceAll("_f", "F").replaceAll("_g", "G").replaceAll("_h", "H").replaceAll("_i", "I").replaceAll("_j", "J").replaceAll("_k", "K").replaceAll("_l", "L").replaceAll("_m", "M").replaceAll("_n", "N").replaceAll("_o", "O").replaceAll("_p", "P").replaceAll("_q", "Q").replaceAll("_r", "R").replaceAll("_s", "S").replaceAll("_t", "T").replaceAll("_u", "U").replaceAll("_v", "V").replaceAll("_w", "W").replaceAll("_x", "X").replaceAll("_y", "Y").replaceAll("_z", "Z");
        return theText;
    }

    @Override
    public String toSnakeCase(String aText) {
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        return this._case.toCase(NormalizeCaseUtility.toNormalized(aText, Delimiter.SNAKE_CASE.getChar()));
    }

    @Override
    public String toPascalCase(String aText) {
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        aText = this.toCamelCase(aText);
        aText = Character.toUpperCase(aText.charAt(0)) + aText.substring(1);
        return aText;
    }

    @Override
    public String toKebabCase(String aText) {
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        return this._case.toCase(NormalizeCaseUtility.toNormalized(aText, Delimiter.KEBAB_CASE.getChar()));
    }

    private static class NormalizeCaseUtility
    extends PropertyBuilderImpl {
        private NormalizeCaseUtility() {
        }

        protected static String toNormalized(String aText, char aSeparator) {
            return PropertyBuilderImpl.toNormalized(aText, aSeparator);
        }
    }
}

