/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.ChangePositionEventImpl;
import org.refcodes.checkerboard.ClickedEvent;
import org.refcodes.checkerboard.ClickedEventImpl;
import org.refcodes.checkerboard.DraggabilityChangedEvent;
import org.refcodes.checkerboard.DraggabilityChangedEventImpl;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerObserver;
import org.refcodes.checkerboard.PositionChangedEvent;
import org.refcodes.checkerboard.PositionChangedEventImpl;
import org.refcodes.checkerboard.StateChangedEvent;
import org.refcodes.checkerboard.StateChangedEventImpl;
import org.refcodes.checkerboard.VisibilityChangedEvent;
import org.refcodes.checkerboard.VisibilityChangedEventImpl;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.Position;
import org.refcodes.observer.AbstractObservable;

public abstract class AbstractPlayer<P extends Player<P, S>, S>
extends AbstractObservable<PlayerObserver<P, S>, PlayerEvent<P>>
implements Player<P, S> {
    private static final ExecutionStrategy STRATEGY = ExecutionStrategy.SEQUENTIAL;
    private int _posX;
    private int _posY;
    private S _state;
    private boolean _isVisible = true;
    private boolean _isDraggable = true;

    public AbstractPlayer() {
    }

    public AbstractPlayer(int aPosX, int aPosY) {
        this._posX = aPosX;
        this._posY = aPosY;
    }

    public AbstractPlayer(Position aPosition) {
        this._posX = aPosition.getPositionX();
        this._posY = aPosition.getPositionY();
    }

    @Override
    public void click() {
        try {
            ClickedEventImpl<AbstractPlayer> theEvent = new ClickedEventImpl<AbstractPlayer>(this);
            this.fireEvent(theEvent, STRATEGY);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    public P withPosition(int aPosX, int aPosY) throws VetoException.VetoRuntimeException {
        this.setPosition(aPosX, aPosY);
        return (P)this;
    }

    public P withPosition(Position aPosition) throws VetoException.VetoRuntimeException {
        this.setPosition(aPosition);
        return (P)this;
    }

    public void setPosition(int aPosX, int aPosY) throws VetoException.VetoRuntimeException {
        if (aPosX != this._posX || aPosY != this._posY) {
            ChangePositionEventImpl<AbstractPlayer> theVetoable = new ChangePositionEventImpl<AbstractPlayer>(aPosX, aPosY, this._posX, this._posY, this);
            try {
                this.fireEvent(theVetoable, STRATEGY);
            }
            catch (VetoException e) {
                throw new VetoException.VetoRuntimeException((Throwable)e);
            }
            PositionChangedEventImpl<AbstractPlayer> theEvent = new PositionChangedEventImpl<AbstractPlayer>(aPosX, aPosY, this._posX, this._posY, this);
            this._posX = aPosX;
            this._posY = aPosY;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public void setPosition(Position aPosition) throws VetoException.VetoRuntimeException {
        this.setPosition(aPosition.getPositionX(), aPosition.getPositionY());
    }

    public P withPositionY(int aPosY) throws VetoException.VetoRuntimeException {
        this.setPositionY(aPosY);
        return (P)this;
    }

    public void setPositionY(int aPosY) throws VetoException.VetoRuntimeException {
        if (aPosY != this._posY) {
            PositionChangedEventImpl<AbstractPlayer> theEvent = new PositionChangedEventImpl<AbstractPlayer>(this._posX, aPosY, this._posX, this._posY, this);
            this._posY = aPosY;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withPositionX(int aPosX) throws VetoException.VetoRuntimeException {
        this.setPositionX(aPosX);
        return (P)this;
    }

    public void setStatus(S aState) {
        if (aState != this._state) {
            StateChangedEventImpl<AbstractPlayer, S> theEvent = new StateChangedEventImpl<AbstractPlayer, S>(aState, this._state, this);
            this._state = aState;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withStatus(S aState) {
        this.setStatus(aState);
        return (P)this;
    }

    public void setPositionX(int aPosX) {
        if (aPosX != this._posX) {
            PositionChangedEventImpl<AbstractPlayer> theEvent = new PositionChangedEventImpl<AbstractPlayer>(aPosX, this._posY, this._posX, this._posY, this);
            this._posX = aPosX;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible != this._isVisible) {
            VisibilityChangedEventImpl<AbstractPlayer> theEvent = new VisibilityChangedEventImpl<AbstractPlayer>(this);
            this._isVisible = isVisible;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withShow() {
        this.setVisible(true);
        return (P)this;
    }

    public P withHide() {
        this.setVisible(false);
        return (P)this;
    }

    public P withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return (P)this;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setDraggable(boolean isDraggable) {
        if (isDraggable != this._isDraggable) {
            DraggabilityChangedEventImpl<AbstractPlayer> theEvent = new DraggabilityChangedEventImpl<AbstractPlayer>(this);
            this._isDraggable = isDraggable;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withDraggable() {
        this.setDraggable(true);
        return (P)this;
    }

    public P withStationary() {
        this.setDraggable(false);
        return (P)this;
    }

    public P withDraggable(boolean isDraggable) {
        this.setDraggable(isDraggable);
        return (P)this;
    }

    public void draggable() {
        this.setDraggable(true);
    }

    public void stationary() {
        this.setDraggable(false);
    }

    public boolean isDraggable() {
        return this._isDraggable;
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    public S getStatus() {
        return this._state;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._posX + ":" + this._posY + ", " + this.getStatus() + ")@" + this.hashCode();
    }

    protected boolean fireEvent(PlayerEvent<P> aEvent, PlayerObserver<P, S> aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
        aObserver.onPlayerEvent(aEvent);
        if (aEvent instanceof ChangePositionEvent) {
            aObserver.onChangePositionEvent((ChangePositionEvent)aEvent);
        }
        if (aEvent instanceof PositionChangedEvent) {
            aObserver.onPositionChangedEvent((PositionChangedEvent)aEvent);
        }
        if (aEvent instanceof ClickedEvent) {
            aObserver.onClickedEvent((ClickedEvent)aEvent);
        }
        if (aEvent instanceof StateChangedEvent) {
            aObserver.onStateChangedEvent((StateChangedEvent)aEvent);
        }
        if (aEvent instanceof VisibilityChangedEvent) {
            aObserver.onVisibilityChangedEvent((VisibilityChangedEvent)aEvent);
        }
        if (aEvent instanceof DraggabilityChangedEvent) {
            aObserver.onDraggabilityChangedEvent((DraggabilityChangedEvent)aEvent);
        }
        return true;
    }
}

