/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component.impls;

import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.component.impls.ConnectionAutomatonImpl;
import org.refcodes.runtime.RuntimeUtility;

public class ConnectionAutomatonTest
implements ConnectionComponent<String>,
ConnectionComponent.ConnectionAutomaton<String> {
    private static Logger LOGGER = Logger.getLogger(ConnectionAutomatonTest.class);
    private static final String ACCEPTED = "ACCEPTED";
    private static final String REJECTED = "REJECTED";

    @Test
    public void testSunnyDayConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assert.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assert.assertTrue((boolean)theConnectionAutomaton.isOpened());
        Assert.assertTrue((boolean)theConnectionAutomaton.isClosable());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.close();
        Assert.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assert.assertTrue((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assert.assertTrue((boolean)theConnectionAutomaton.isOpened());
        Assert.assertTrue((boolean)theConnectionAutomaton.isClosable());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosed());
    }

    @Test
    public void testRainyDayConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assert.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        try {
            theConnectionAutomaton.open((Object)ACCEPTED);
            Assert.fail((String)"Component must not be openable.");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        theConnectionAutomaton.close();
        theConnectionAutomaton.close();
    }

    @Test
    public void tesBadConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)REJECTED));
        Assert.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assert.assertFalse((boolean)theConnectionAutomaton.isClosed());
        try {
            theConnectionAutomaton.open((Object)REJECTED);
            Assert.fail((String)"Component must not be openable.");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        theConnectionAutomaton.close();
        theConnectionAutomaton.close();
    }

    public void open(String aConnection) throws OpenException {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        if (!this.isOpenable(aConnection)) {
            // empty if block
        }
    }

    public void close() {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
    }

    public boolean isOpenable(String aConnection) {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        return aConnection.equals(ACCEPTED);
    }

    public boolean isOpened() {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        throw new UnsupportedOperationException("*** OPERATION NOT SUPPORTED ***");
    }

    public boolean isClosable() {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        throw new UnsupportedOperationException("*** OPERATION NOT SUPPORTED ***");
    }

    public boolean isClosed() {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        throw new UnsupportedOperationException("*** OPERATION NOT SUPPORTED ***");
    }

    public ConnectionStatus getConnectionStatus() {
        LOGGER.info((Object)RuntimeUtility.toFullyQualifiedMethodName());
        throw new UnsupportedOperationException("*** OPERATION NOT SUPPORTED ***");
    }
}

