/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.DeviceAutomatonImpl;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.OpenException;

public class DeviceAutomatonTest
implements LinkComponent {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testSunnyDayConnection() throws OpenException {
        DeviceAutomatonImpl theDeviceAutomaton = new DeviceAutomatonImpl((LinkComponent)this);
        Assertions.assertTrue((boolean)theDeviceAutomaton.isOpenable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isOpened());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosed());
        theDeviceAutomaton.open();
        Assertions.assertFalse((boolean)theDeviceAutomaton.isOpenable());
        Assertions.assertTrue((boolean)theDeviceAutomaton.isOpened());
        Assertions.assertTrue((boolean)theDeviceAutomaton.isClosable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosed());
        theDeviceAutomaton.close();
        Assertions.assertTrue((boolean)theDeviceAutomaton.isOpenable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isOpened());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosable());
        Assertions.assertTrue((boolean)theDeviceAutomaton.isClosed());
        theDeviceAutomaton.open();
        Assertions.assertFalse((boolean)theDeviceAutomaton.isOpenable());
        Assertions.assertTrue((boolean)theDeviceAutomaton.isOpened());
        Assertions.assertTrue((boolean)theDeviceAutomaton.isClosable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosed());
    }

    @Test
    public void testRainyDayConnection() throws OpenException {
        DeviceAutomatonImpl theDeviceAutomaton = new DeviceAutomatonImpl((LinkComponent)this);
        Assertions.assertTrue((boolean)theDeviceAutomaton.isOpenable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isOpened());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosable());
        Assertions.assertFalse((boolean)theDeviceAutomaton.isClosed());
        theDeviceAutomaton.open();
        try {
            theDeviceAutomaton.open();
            Assertions.fail((String)"Component must not be openable.");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        theDeviceAutomaton.close();
        theDeviceAutomaton.close();
    }

    public void open() throws OpenException {
        if (IS_LOG_TESTS) {
            System.out.println("open");
        }
    }

    public void close() {
        if (IS_LOG_TESTS) {
            System.out.println("close");
        }
    }
}

