/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.impls;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.ShortBufferException;
import org.apache.commons.collections.map.ReferenceMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.refcodes.controlflow.impls.RetryCounterImpl;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.DecryptionProvider;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.traps.NoCipherUidException;
import org.refcodes.forwardsecrecy.traps.UnknownCipherUidException;
import org.refcodes.forwardsecrecy.utils.ForwardSecrecyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.security.traps.DecryptionException;

public class DecryptionProviderImpl
implements DecryptionProvider {
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private DecryptionService _decryptionService;
    private Provider _jceProvider;
    private String _jceAlgorithm;
    private Map<String, StandardPBEStringEncryptor> _cipherUidToStringEncryptor = new ReferenceMap();

    public DecryptionProviderImpl(DecryptionService aDecryptionService, Provider aJceProvider, String aJceAlgorithm) {
        this._decryptionService = aDecryptionService;
        this._jceProvider = aJceProvider;
        this._jceAlgorithm = aJceAlgorithm;
    }

    public DecryptionProviderImpl(DecryptionService aDecryptionService) {
        this(aDecryptionService, (Provider)new BouncyCastleProvider(), "PBEWITHSHA256AND128BITAES-CBC-BC");
    }

    @Override
    public String toDecrypted(String aInput) throws UnknownCipherUidException, NoCipherUidException {
        String theCipherUid = ForwardSecrecyUtility.toCipherUidPrefix(aInput);
        if (theCipherUid == null || theCipherUid.length() == 0) {
            throw new NoCipherUidException("No cipher UID has been provided by the encrypted text to be decrypted!");
        }
        CipherVersion theCipherVersion = this.getCipherVersion(theCipherUid);
        String theEncyrptedText = ForwardSecrecyUtility.toEncryptedTextBody(aInput);
        StringEncryptor theTextEncryptor = this.getStringEncryptor(theCipherVersion);
        String theDecryptedText = theTextEncryptor.decrypt(theEncyrptedText);
        return theDecryptedText;
    }

    public int toDecrypted(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws ShortBufferException, DecryptionException {
        byte[] theOutputHex;
        String theInputText;
        byte[] theInputHex = Arrays.copyOfRange(aInput, aInputOffset, aInputOffset + aInputLength);
        try {
            theInputText = new String(theInputHex, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            theInputText = new String(theInputHex);
        }
        String theOutputText = this.toDecrypted(theInputText);
        try {
            theOutputHex = theOutputText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            theOutputHex = theOutputText.getBytes();
        }
        if (aOutput.length < aOutputOffset + theOutputHex.length) {
            throw new ShortBufferException("The decrypted data is of length <" + theOutputHex.length + "> though your buffer with length <" + aOutput.length + "> does not provide enugh elements after offset <" + aOutputOffset + ">.");
        }
        for (int i = 0; i < theOutputHex.length; ++i) {
            aOutput[aOutputOffset + i] = theOutputHex[i];
        }
        return theOutputHex.length;
    }

    private CipherVersion getCipherVersion(String aCipherUid) throws UnknownCipherUidException {
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 1500L, 100L);
        while (theRetryCounter.nextRetry()) {
            List<CipherVersion> theCipherVersions = this._decryptionService.getCipherVersions();
            if (theCipherVersions != null) {
                for (CipherVersion eCipherVersion : theCipherVersions) {
                    if (!eCipherVersion.getUniversalId().equals(aCipherUid)) continue;
                    return eCipherVersion;
                }
            }
            if (!theRetryCounter.hasNextRetry()) continue;
            LOGGER.warn("No cipher found for cipher UID \"" + aCipherUid + "\", retry count is <" + theRetryCounter.getRetryCount() + "> of <" + theRetryCounter.getRetryNumber() + "> (waiting for <" + theRetryCounter.getNextRetryDelayInMs() / 1000L + "> seconds before next retry) ...");
        }
        throw new UnknownCipherUidException(aCipherUid, "No cipher version found for cipher UID \"" + aCipherUid + "\" after <" + theRetryCounter.getRetryNumber() + "> retries!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringEncryptor getStringEncryptor(CipherVersion aCipherVersion) {
        StandardPBEStringEncryptor theStringEncryptor = this._cipherUidToStringEncryptor.get(aCipherVersion);
        if (theStringEncryptor == null) {
            DecryptionProviderImpl decryptionProviderImpl = this;
            synchronized (decryptionProviderImpl) {
                theStringEncryptor = this._cipherUidToStringEncryptor.get(aCipherVersion);
                if (theStringEncryptor == null) {
                    theStringEncryptor = new StandardPBEStringEncryptor();
                    theStringEncryptor.setProvider(this._jceProvider);
                    theStringEncryptor.setAlgorithm(this._jceAlgorithm);
                    theStringEncryptor.setPassword(aCipherVersion.getCipher());
                    this._cipherUidToStringEncryptor.put(aCipherVersion.getUniversalId(), theStringEncryptor);
                }
            }
        }
        return theStringEncryptor;
    }
}

