/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.impls;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.refcodes.exception.utils.ExceptionUtility;
import org.refcodes.forwardsecrecy.EncryptionProvider;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.utils.ForwardSecrecyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.security.traps.EncryptionException;

public class EncryptionProviderImpl
implements EncryptionProvider {
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private EncryptionService _encryptionService;
    private StandardPBEStringEncryptor _stringEncryptor;
    private String _cipherUid = null;
    private Provider _jceProvider;
    private String _jceAlgorithm;

    public EncryptionProviderImpl(EncryptionService aEncryptionService, Provider aJceProvider, String aJceAlgorithm) {
        this._encryptionService = aEncryptionService;
        this._jceProvider = aJceProvider;
        this._jceAlgorithm = aJceAlgorithm;
        this.nextCipherVersion();
    }

    public EncryptionProviderImpl(EncryptionService aEncryptionService) {
        this(aEncryptionService, (Provider)new BouncyCastleProvider(), "PBEWITHSHA256AND128BITAES-CBC-BC");
    }

    @Override
    public String toEncrypted(String aInput) throws EncryptionException {
        if (ForwardSecrecyUtility.hasEncryptionPattern(aInput)) {
            LOGGER.warn("The provided text may have already been encrypted with a cipher UID beginning with \"" + aInput.substring(0, 14) + "...\"!");
        }
        try {
            return this._cipherUid + ':' + this._stringEncryptor.encrypt(aInput);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException e) {
            throw new EncryptionException(ExceptionUtility.toMessage((Throwable)e), e);
        }
    }

    public int toEncrypted(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws ShortBufferException, EncryptionException {
        byte[] theOutputHex;
        String theInputText;
        byte[] theInputHex = Arrays.copyOfRange(aInput, aInputOffset, aInputOffset + aInputLength);
        try {
            theInputText = new String(theInputHex, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            theInputText = new String(theInputHex);
        }
        String theOutputText = this.toEncrypted(theInputText);
        try {
            theOutputHex = theOutputText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            theOutputHex = theOutputText.getBytes();
        }
        if (aOutput.length < aOutputOffset + theOutputHex.length) {
            throw new ShortBufferException("The encrypted data is of length <" + theOutputHex.length + "> though your buffer with length <" + aOutput.length + "> does not provide enugh elements after offset <" + aOutputOffset + ">.");
        }
        for (int i = 0; i < theOutputHex.length; ++i) {
            aOutput[aOutputOffset + i] = theOutputHex[i];
        }
        return theOutputHex.length;
    }

    @Override
    public void nextCipherVersion() {
        Object theCipherVersion = this._encryptionService.next();
        this._stringEncryptor = new StandardPBEStringEncryptor();
        this._stringEncryptor.setProvider(this._jceProvider);
        this._stringEncryptor.setAlgorithm(this._jceAlgorithm);
        this._stringEncryptor.setPassword(theCipherVersion.getCipher());
        this._cipherUid = theCipherVersion.getUniversalId();
    }
}

