/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical.utils;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public final class GraphicalUtility {
    private GraphicalUtility() {
    }

    public static int toGray(int aRgbValue) {
        return (GraphicalUtility.getRed(aRgbValue) + GraphicalUtility.getGreen(aRgbValue) + GraphicalUtility.getBlue(aRgbValue)) / 3;
    }

    public static int toRgb(int aAlpha, int aRed, int aGreen, int aBlue) {
        return (aAlpha << 24) + (aRed << 16) + (aGreen << 8) + aBlue;
    }

    public static int getAlpha(int aRgbValue) {
        return aRgbValue >> 24 & 0xFF;
    }

    public static int getRed(int aRgbValue) {
        return aRgbValue >> 16 & 0xFF;
    }

    public static int getGreen(int aRgbValue) {
        return aRgbValue >> 8 & 0xFF;
    }

    public static int getBlue(int aRgbValue) {
        return aRgbValue & 0xFF;
    }

    public static Font getFont(String aText, int aWidth, String aFontName, int aFontStyle) {
        Font eFont;
        int theFontSize = 5;
        Font ePreviousFont = null;
        int eWidth = 0;
        do {
            if ((eWidth = GraphicalUtility.toPixelWidth(aText, eFont = new Font(aFontName, aFontStyle, theFontSize))) < aWidth) {
                ePreviousFont = eFont;
            }
            ++theFontSize;
        } while (eWidth < aWidth);
        if (eWidth == aWidth) {
            return eFont;
        }
        if (ePreviousFont == null) {
            throw new IllegalArgumentException("Unable to determine the font size for font \"" + aFontName + "\" with style \"" + aFontStyle + "\" for text \"" + aText + "\" to fit into a width of y <" + aWidth + "> as the smallest font already exceeds this width with width <" + eWidth + ">.");
        }
        return ePreviousFont;
    }

    private static int toPixelWidth(String aText, Font aFont) {
        int theImageType = 10;
        BufferedImage theImage = new BufferedImage(1, 1, theImageType);
        Graphics theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont);
        FontMetrics theFontMetrics = theGraphics.getFontMetrics();
        int theWidth = theFontMetrics.stringWidth(aText);
        int theHeight = theFontMetrics.getHeight();
        theImage = new BufferedImage(theWidth, theHeight, theImageType);
        theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont);
        Graphics2D theGraphics2d = (Graphics2D)theGraphics;
        theGraphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        theGraphics2d.drawString(aText, 0, theHeight);
        int theTrimBegin = theWidth;
        int theTrimEnd = 0;
        block0: for (int y = 0; y < theHeight; ++y) {
            int eGray;
            int x;
            for (x = 0; x < theWidth; ++x) {
                eGray = GraphicalUtility.toGray(theImage.getRGB(x, y));
                if (eGray <= 0 || x >= theTrimBegin) continue;
                theTrimBegin = x;
                break;
            }
            for (x = theWidth - 1; x >= 0; --x) {
                eGray = GraphicalUtility.toGray(theImage.getRGB(x, y));
                if (eGray <= 0 || x <= theTrimEnd) continue;
                theTrimEnd = x;
                continue block0;
            }
        }
        return theTrimEnd - theTrimBegin + 1;
    }
}

