// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical.impls;

import org.junit.Test;
import org.refcodes.data.ext.boulderdash.BoulderDashPixmap;
import org.refcodes.data.ext.boulderdash.impls.BoulderDashPixmapInputStreamFactoryImpl;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImageBuilder;

/**
 * @author steiner
 *
 */
public class RgbPixmapImageBuilderTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testBoulderDashPixmap() {
		RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilderImpl();
		theBuilder.withImageInputStream( new BoulderDashPixmapInputStreamFactoryImpl().createInstance( BoulderDashPixmap.ROCKFORD_FACING_FORWARD ) );
		RgbPixmap thePixmap = theBuilder.toPixmap();
		String eHexString;

		for ( int y = 0; y < thePixmap.getPixmapHeight(); y++ ) {
			for ( int x = 0; x < thePixmap.getPixmapWidth(); x++ ) {
				eHexString = Integer.toHexString( thePixmap.getPixelAt( x, y ).toRgbValue() );
				while ( eHexString.length() < 8 ) {
					eHexString = "0" + eHexString;
				}
				System.out.print( eHexString );
				if ( x < thePixmap.getPixmapWidth() ) System.out.print( " " );
			}
			System.out.println();
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
