// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a min grid dimension property.
 */
public interface MinGridDimension {

	/**
	 * Retrieves the min grid dimension from the min grid dimension property.
	 * 
	 * @return The min grid dimension stored by the min grid dimension property.
	 */
	GridDimension getMinGridDimension();

	/**
	 * Provides a mutator for a min grid dimension property.
	 */
	public interface MinGridDimensionMutator {

		/**
		 * Sets the min grid dimension for the min grid dimension property.
		 * 
		 * @param aGridDimension The min grid dimension to be stored by the grid
		 *        dimension property.
		 */
		void setMinGridDimension( GridDimension aGridDimension );

		/**
		 * Sets the min grid dimension for the min grid dimension property.
		 * 
		 * @param aGridWidth The min grid width to be stored by the min grid
		 *        dimension property.
		 * 
		 * @param aGridHeight The min grid height to be stored by the min grid
		 *        dimension property.
		 */
		void setMinGridDimension( int aGridWidth, int aGridHeight );

	}

	/**
	 * Provides a builder method for a min grid dimension property returning the
	 * builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface MinGridDimensionBuilder<B extends MinGridDimensionBuilder<B>> {

		/**
		 * Sets the min grid dimension for the min grid dimension property.
		 * 
		 * @param aGridWidth The min grid width to be stored by the min grid
		 *        dimension property.
		 * 
		 * @param aGridHeight The min grid height to be stored by the min grid
		 *        dimension property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withMinGridDimension( int aGridWidth, int aGridHeight );

		/**
		 * Sets the min grid dimension for the min grid dimension property.
		 * 
		 * @param aGridDimension The min grid dimension to be stored by the min
		 *        grid dimension property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withMinGridDimension( GridDimension aGridDimension );

	}

	/**
	 * Provides a min grid dimension property.
	 */
	public interface MinGridDimensionProperty extends MinGridDimension, MinGridDimensionMutator {}

	/**
	 * Provides a min grid dimension property builder.
	 */
	public interface MinGridDimensionPropertyBuilder extends MinGridDimensionProperty, MinGridDimensionBuilder<MinGridDimensionPropertyBuilder> {}

}
