// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.graphical;

/**
 * Provides an accessor for a Y vector property.
 */
public interface Vector extends VectorXAccessor, VectorYAccessor {

	/**
	 * The Interface VectorMutator.
	 */
	public interface VectorMutator extends VectorXMutator, VectorYMutator {

		/**
		 * Sets the vector.
		 *
		 * @param aVectorX the vector X
		 * @param aVectorY the vector Y
		 */
		void setVector( int aVectorX, int aVectorY );

		/**
		 * Sets the vector.
		 *
		 * @param aVector the new vector
		 */
		void setVector( Vector aVector );
	}

	/**
	 * The Interface VectorBuilder.
	 *
	 * @param <B> the generic type
	 */
	public interface VectorBuilder<B extends VectorBuilder<B>> extends VectorXBuilder<B>, VectorYBuilder<B> {

		/**
		 * With vector.
		 *
		 * @param aVectorX the vector X
		 * @param aVectorY the vector Y
		 * @return the b
		 */
		B withVector( int aVectorX, int aVectorY );

		/**
		 * With vector.
		 *
		 * @param aVector the vector
		 * @return the b
		 */
		B withVector( Vector aVector );
	}

	/**
	 * The Interface VectorProperty.
	 */
	public interface VectorProperty extends Vector, VectorMutator, VectorXProperty, VectorYProperty {}

	/**
	 * The Interface VectorPropertyBuilder.
	 */
	public interface VectorPropertyBuilder extends VectorProperty, VectorBuilder<VectorPropertyBuilder> {}

	/**
	 * Equals.
	 *
	 * @param aVectorA the vector A
	 * @param aVectorB the vector B
	 * @return true, if successful
	 */
	static boolean equals( Vector aVectorA, Vector aVectorB ) {
		return aVectorA.getVectorX() == aVectorB.getVectorX() && aVectorA.getVectorY() == aVectorB.getVectorY();
	}
}
