// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io.utils;

import static org.junit.Assert.assertEquals;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.junit.Test;
import org.refcodes.io.utils.FileUtility;
import org.refcodes.textual.utils.SeparatedValuesUtility;

public class FileUtilityTest {

	private static Logger LOGGER = Logger.getLogger( FileUtilityTest.class );

	// @formatter:off
	private static final String[][] ZIP_FILE_NAMES = new String[][] {
		{"test.log.zip", "test.log"},
		{"test.log.ZIP", "test.log"},
		{"home/user/test.log.zip", "home/user/test.log"},
		{".zip", ""}
	};
	// @formatter:on

	@Test
	public void toAutoDetectInputStream() {
		for ( int i = 0; i < ZIP_FILE_NAMES.length; i++ ) {
			LOGGER.info( "In:      \"" + ZIP_FILE_NAMES[i][0] + "\"" );
			LOGGER.info( "Out:     \"" + FileUtility.toFileNameFromZip( ZIP_FILE_NAMES[i][0] ) + "\"" );
			LOGGER.info( "Expected:\"" + ZIP_FILE_NAMES[i][1] + "\"" );
			assertEquals( ZIP_FILE_NAMES[i][1], FileUtility.toFileNameFromZip( ZIP_FILE_NAMES[i][0] ) );
		}
	}

	@Test
	public void toJarHierarchy() throws MalformedURLException {
		URL theJarPath1 = new URL( "jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml" );
		URL theJarPath2 = new URL( "jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/lib/fightclub-adapter-web-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml" );
		String[] theJarHierarchy;
		String theJarPath;

		theJarHierarchy = FileUtility.toJarHierarchy( theJarPath1 );
		theJarPath = SeparatedValuesUtility.toSeparatedValues( theJarHierarchy, '/' );
		LOGGER.info( "JAR parh 1 := " + theJarPath );
		assertEquals( "fightclub-app-0.0.1-SNAPSHOT.jar", theJarPath );

		theJarHierarchy = FileUtility.toJarHierarchy( theJarPath2 );
		theJarPath = SeparatedValuesUtility.toSeparatedValues( theJarHierarchy, '/' );
		LOGGER.info( "JAR parh 2 := " + theJarPath );
		assertEquals( "fightclub-app-0.0.1-SNAPSHOT.jar/fightclub-adapter-web-0.0.1-SNAPSHOT.jar", theJarPath );

	}
}
