// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io.impls;

import static org.junit.Assert.*;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;
import org.junit.Test;
import org.refcodes.data.DelimeterConsts;
import org.refcodes.io.FileUtility;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.impls.CsvBuilderImpl;

public class FileUtilityTest {

	private static Logger LOGGER = Logger.getLogger( FileUtilityTest.class );

	@Test
	public void toJarHierarchy() throws MalformedURLException {
		URL theJarPath1 = new URL( "jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml" );
		URL theJarPath2 = new URL( "jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/lib/fightclub-adapter-web-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml" );
		String[] theJarHierarchy;
		String theJarPath;

		theJarHierarchy = FileUtility.toJarHierarchy( theJarPath1 );
		theJarPath = new CsvBuilderImpl().withCsvEscapeMode( CsvEscapeMode.ESCAPED ).withFields( theJarHierarchy ).withDelimiterChar( DelimeterConsts.PATH_DELIMETER ).toRecord();
		LOGGER.info( "JAR parh 1 := " + theJarPath );
		assertEquals( "fightclub-app-0.0.1-SNAPSHOT.jar", theJarPath );

		theJarHierarchy = FileUtility.toJarHierarchy( theJarPath2 );
		theJarPath = new CsvBuilderImpl().withCsvEscapeMode( CsvEscapeMode.ESCAPED ).withFields( theJarHierarchy ).withDelimiterChar( DelimeterConsts.PATH_DELIMETER ).toRecord();
		LOGGER.info( "JAR parh 2 := " + theJarPath );
		assertEquals( "fightclub-app-0.0.1-SNAPSHOT.jar/fightclub-adapter-web-0.0.1-SNAPSHOT.jar", theJarPath );
	}
}