/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io.impls;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.component.impls.AbstractConnectableAutomaton;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.Receiver;
import org.refcodes.io.impls.SerializableObjectInputStreamImpl;

public abstract class AbstractInputStreamReceiver<DATA extends Serializable>
extends AbstractConnectableAutomaton
implements Receiver<DATA> {
    private LinkedList<DATA> _datagramQueue = new LinkedList();
    private ObjectInputStream _inputStream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDatagram() throws OpenException {
        if (!this._datagramQueue.isEmpty()) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            Object theObject = this._inputStream.readObject();
            if (theObject == null) {
                if (this.isClosed()) {
                    return false;
                }
                this.close();
                LinkedList<DATA> linkedList = this._datagramQueue;
                synchronized (linkedList) {
                    this._datagramQueue.notifyAll();
                }
                return false;
            }
            this._datagramQueue.add((Serializable)theObject);
            return true;
        }
        catch (CloseException e) {
            LinkedList<DATA> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
        }
        catch (IOException ioe) {
            if (this.isClosed()) {
                return false;
            }
            LinkedList<DATA> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            try {
                if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)ioe)) {
                    super.close();
                } else {
                    this.close();
                }
            }
            catch (CloseException e) {
                throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
            }
            throw new OpenException("Unable to test datagram availability, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)ioe);
        }
        catch (ClassNotFoundException e) {
            throw new OpenException("Datagram read is of unknown type, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
        }
    }

    @Override
    public DATA readDatagram() throws OpenException, InterruptedException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        if (!this.hasDatagram()) {
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        Serializable theDatagram = (Serializable)this._datagramQueue.poll();
        while (theDatagram == null) {
            if (this.hasDatagram()) continue;
            throw new OpenException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        return (DATA)theDatagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        LinkedList<DATA> linkedList = this._datagramQueue;
        synchronized (linkedList) {
            this._datagramQueue.notifyAll();
        }
    }

    public synchronized void close() throws CloseException {
        block3: {
            if (!this.isClosed()) {
                super.close();
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)e)) break block3;
                    throw new CloseException("Unable to close receiver, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
                }
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._inputStream = !(aInputStream instanceof BufferedInputStream) ? new SerializableObjectInputStreamImpl(new BufferedInputStream(aInputStream)) : new SerializableObjectInputStreamImpl(aInputStream);
        }
        catch (IOException aException) {
            throw new OpenException("Unable to open the I/O stream receiver as of a causing exception.", (Throwable)aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected boolean isOpenable(InputStream aInputStream) {
        if (aInputStream == null) {
            return false;
        }
        return !this.isOpened();
    }
}

