// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.util.Arrays;

import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.OpenException;

/**
 * The {@link AbstractByteSender} is a base abstract implementation of the
 * {@link ByteSender} interface providing common functionality for concrete real
 * live {@link ByteDatagramSender} and {@link ByteBlockSender} (=
 * {@link ByteSender}) implementations.
 */
public abstract class AbstractByteSender extends AbstractConnectableAutomaton implements ByteSender {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( byte[] aDatagrams, int aOffset, int aLength ) throws OpenException {
		writeDatagrams( Arrays.copyOfRange( aDatagrams, aOffset, aOffset + aLength ) );
	}
}