// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import org.refcodes.component.Closable;
import org.refcodes.component.OpenException;

/**
 * (as {@link java.io.InputStream} does not provide some useful *interface*)
 * 
 * @see java.io.InputStream
 */
public interface ByteDatagramInputStream extends Closable {

	/**
	 * Read.
	 *
	 * @return the int
	 * @throws OpenException the open exception
	 */
	int read() throws OpenException;

	/**
	 * Read.
	 *
	 * @param b the b
	 * @return the int
	 * @throws OpenException the open exception
	 */
	int read( byte b[] ) throws OpenException;

	/**
	 * Read.
	 *
	 * @param b the b
	 * @param off the off
	 * @param len the len
	 * @return the int
	 * @throws OpenException the open exception
	 */
	int read( byte b[], int off, int len ) throws OpenException;

	/**
	 * Skip.
	 *
	 * @param n the n
	 * @return the long
	 * @throws OpenException the open exception
	 */
	long skip( long n ) throws OpenException;

	/**
	 * Available.
	 *
	 * @return the int
	 * @throws OpenException the open exception
	 */
	int available() throws OpenException;

	// void close() throws CloseException;

	/**
	 * Mark.
	 *
	 * @param readlimit the readlimit
	 */
	void mark( int readlimit );

	/**
	 * Reset.
	 *
	 * @throws OpenException the open exception
	 */
	void reset() throws OpenException;

	/**
	 * Mark supported.
	 *
	 * @return true, if successful
	 */
	boolean markSupported();

}