// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.OutputStream;

/**
 * Provides an accessor for a Output-Stream property.
 */
public interface OutputStreamAccessor {

	/**
	 * Retrieves the {@link OutputStream} from the Output-Stream property.
	 * 
	 * @return The {@link OutputStream} stored by the Output-Stream property.
	 */
	OutputStream getOutputStream();

	/**
	 * Provides a mutator for a Output-Stream property.
	 */
	public interface OutputStreamMutator {

		/**
		 * Sets the {@link OutputStream} for the Output-Stream property.
		 * 
		 * @param aOutputStream The {@link OutputStream} to be stored by the
		 *        Output-Stream property.
		 */
		void setOutputStream( OutputStream aOutputStream );
	}

	/**
	 * Provides a builder method for a Output-Stream property returning the
	 * builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface OutputStreamBuilder<B extends OutputStreamBuilder<B>> {

		/**
		 * Sets the {@link OutputStream} for the Output-Stream property.
		 * 
		 * @param aOutputStream The {@link OutputStream} to be stored by the
		 *        Output-Stream property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withOutputStream( OutputStream aOutputStream );
	}

	/**
	 * Provides a Output-Stream property.
	 */
	public interface OutputStreamProperty extends OutputStreamAccessor, OutputStreamMutator {}
}
