// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.refcodes.component.OpenException;

/**
 * The Interface Provider.
 *
 * @param <DATA> the generic type
 */
@FunctionalInterface
public interface Provider<DATA extends Serializable> extends DatagramProvider<DATA>, BlockProvider<DATA> {

	/**
	 * Caution: Reads till an {@link OpenException} (or an
	 * {@link InterruptedException} in case of blocking till more data is
	 * available) occurs.
	 *
	 * {@inheritDoc}
	 */
	@Override
	default DATA[] readDatagrams() throws OpenException, InterruptedException {
		return readDatagrams( -1 );
	}

	@SuppressWarnings("unchecked")
	@Override
	default DATA[] readDatagrams( int aBlockSize ) throws OpenException, InterruptedException {
		List<DATA> theDatagrams = new ArrayList<>();
		try {
			if ( aBlockSize > 0 ) {
				for ( int i = 0; i < aBlockSize; i++ ) {
					theDatagrams.add( readDatagram() );
				}
			}
			else {
				while ( true ) {
					theDatagrams.add( readDatagram() );
				}
			}
		}
		catch ( OpenException | InterruptedException e ) {
			if ( theDatagrams.isEmpty() ) {
				throw e;
			}
		}
		return theDatagrams.toArray( (DATA[]) (new Object[theDatagrams.size()]) );
	}

}
