// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

import org.refcodes.component.OpenException;

/**
 * The Interface Sender.
 *
 * @param <DATA> the generic type
 */
public interface Sender<DATA extends Serializable> extends Consumer<DATA>, DatagramSender<DATA>, BlockSender<DATA> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void writeDatagrams( DATA[] aDatagrams, int aOffset, int aLength ) throws OpenException {
		for ( int i = 0; i < aLength; i++ ) {
			writeDatagram( aDatagrams[aOffset + i] );
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void flush() throws OpenException {}

}
