/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer.impls;

import org.apache.log4j.Logger;
import org.junit.Test;
import org.refcodes.controlflow.consts.ExecutionStrategy;
import org.refcodes.exception.traps.VetoException;
import org.refcodes.observer.TestObserver;
import org.refcodes.observer.impls.AbstractObservable;

public class ObservableTest
extends AbstractObservable<TestObserver, String> {
    private static Logger LOGGER = Logger.getLogger(ObservableTest.class);
    private static final String JOIN = ExecutionStrategy.JOIN.name();
    private static final String PARALLEL = ExecutionStrategy.PARALLEL.name();
    private static final String SEQUENTIAL = ExecutionStrategy.SEQUENTIAL.name();

    @Test
    public void testObservable() throws VetoException {
        this.subscribeObserver(new TestEventListener1());
        this.subscribeObserver(new TestEventListener2());
        this.fireEvent(JOIN, ExecutionStrategy.JOIN);
        this.fireEvent(PARALLEL, ExecutionStrategy.PARALLEL);
        this.fireEvent(SEQUENTIAL, ExecutionStrategy.SEQUENTIAL);
    }

    protected boolean fireEvent(String aEvent, TestObserver aEventListener, ExecutionStrategy aEventExecutionStrategy) throws VetoException {
        if (SEQUENTIAL.equals(aEvent)) {
            return aEventListener.pushSequentialEvent(aEvent);
        }
        if (PARALLEL.equals(aEvent)) {
            aEventListener.pushConcurrentEvent(aEvent);
        }
        if (JOIN.equals(aEvent)) {
            return aEventListener.pushJoinEvent(aEvent);
        }
        return true;
    }

    private class TestEventListener2
    implements TestObserver {
        private TestEventListener2() {
        }

        @Override
        public boolean pushSequentialEvent(String aEvent) throws VetoException {
            LOGGER.info((Object)("TestEventListener2.pushSequentialEvent(): \"" + aEvent + "\""));
            return true;
        }

        @Override
        public void pushConcurrentEvent(String aEvent) {
            LOGGER.info((Object)("TestEventListener2.pushConcurrentEvent(): \"" + aEvent + "\""));
        }

        @Override
        public boolean pushJoinEvent(String aEvent) throws VetoException {
            LOGGER.info((Object)("TestEventListener2.pushJoinEvent(): \"" + aEvent + "\""));
            return true;
        }
    }

    private class TestEventListener1
    implements TestObserver {
        private TestEventListener1() {
        }

        @Override
        public boolean pushSequentialEvent(String aEvent) throws VetoException {
            LOGGER.info((Object)("TestEventListener1.pushSequentialEvent(): \"" + aEvent + "\""));
            return true;
        }

        @Override
        public void pushConcurrentEvent(String aEvent) {
            LOGGER.info((Object)("TestEventListener1.pushConcurrentEvent(): \"" + aEvent + "\""));
        }

        @Override
        public boolean pushJoinEvent(String aEvent) throws VetoException {
            LOGGER.info((Object)("TestEventListener1.pushJoinEvent(): \"" + aEvent + "\""));
            return true;
        }
    }
}

