package org.refcodes.observer;

public class ActionMetaDataEventImpl extends AbstractActionMetaDataEvent<Enum<?>, EventMetaData, Object> implements ActionMetaDataEvent {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an event with the according properties.
	 * 
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Class<?> aPublisherType, Object aSource ) {
		super( new EventMetaDataImpl( aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the according properties.
	 * 
	 * @param aChannel The channel name on which the event is receivable.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( String aChannel, Object aSource ) {
		super( new EventMetaDataImpl( aChannel ), aSource );
	}

	/**
	 * Constructs an event with the given values for the according properties.
	 * 
	 * @param aAlias The alias property.
	 * @param aGroup The group property.
	 * @param aChannel The channel property.
	 * @param aUid The UID (Universal-ID) property.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType, Object aSource ) {
		super( new EventMetaDataImpl( aAlias, aGroup, aChannel, aUid, aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the according properties.
	 * 
	 * @param aAction The action which this represents.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Enum<?> aAction, Class<?> aPublisherType, Object aSource ) {
		super( aAction, new EventMetaDataImpl( aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the according properties.
	 * 
	 * @param aAction The action which this represents.
	 * @param aChannel The channel name on which the event is receivable.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Enum<?> aAction, String aChannel, Object aSource ) {
		super( aAction, new EventMetaDataImpl( aChannel ), aSource );
	}

	/**
	 * Constructs an event with the given values for the according properties.
	 * 
	 * @param aAction The action which this represents.
	 * @param aAlias The alias property.
	 * @param aGroup The group property.
	 * @param aChannel The channel property.
	 * @param aUid The UID (Universal-ID) property.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Enum<?> aAction, String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType, Object aSource ) {
		super( aAction, new EventMetaDataImpl( aAlias, aGroup, aChannel, aUid, aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( EventMetaData aEventMetaData, Object aSource ) {
		super( aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Enum<?> aAction, EventMetaData aEventMetaData, Object aSource ) {
		super( aAction, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Enum<?> aAction, Object aSource ) {
		super( aAction, new EventMetaDataImpl(), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 *
	 * @param aSource The source from which this event originated.
	 */
	public ActionMetaDataEventImpl( Object aSource ) {
		super( new EventMetaDataImpl(), aSource );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
