/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.server.EnableEurekaServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
@EnableAutoConfiguration
@EnableEurekaServer
public class EurekaServer {
    private ConfigurableApplicationContext _ctx;

    public EurekaServer() {
    }

    public EurekaServer(String[] args) {
        this.start(args);
    }

    public EurekaServer(int aPort) {
        String[] args = new String[]{"--server.port=" + aPort, "--eureka.client.serviceUrl.defaultZone=http://localhost:" + aPort + "/eureka"};
        this.start(args);
    }

    public static void main(String[] args) {
        new EurekaServer(args);
    }

    public void start(String[] args) {
        this._ctx = SpringApplication.run(EurekaServer.class, (String[])args);
    }

    public void destroy() {
        SpringApplication.exit((ApplicationContext)this._ctx, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
    }
}

