package org.refcodes.rest;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import org.refcodes.component.OpenException;
import org.refcodes.data.Protocol;
import org.refcodes.net.FormFields;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.rest.impls.HttpRestClientSingleton;

/**
 * Declarative syntactic sugar which may be statically imported in order to
 * allow declarative definitions of REST client functionality:
 * 
 * <code>import static org.refcodes.rest.HttpRestClientSugar.*; </code>
 */
public class HttpRestClientSugar {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also {@link HttpRestClient#open()}
	 *
	 * @throws OpenException the open exception
	 */
	public static void open() throws OpenException {
		HttpRestClientSingleton.getInstance().open();
	}

	/**
	 * See also {@link HttpRestClient#open(File, String)}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @throws OpenException the open exception
	 */
	public static void open( File aKeyStoreFile, String aKeyStorePassword ) throws OpenException {
		HttpRestClientSingleton.getInstance().open( aKeyStoreFile, aKeyStorePassword );
	}

	/**
	 * See also {@link HttpRestClient#open(File, String, String)}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStoreType The key store type
	 * @param aKeyStorePassword The key store password
	 * @throws OpenException the open exception
	 */
	public static void open( File aKeyStoreFile, String aKeyStoreType, String aKeyStorePassword ) throws OpenException {
		HttpRestClientSingleton.getInstance().open( aKeyStoreFile, aKeyStoreType, aKeyStorePassword );
	}

	/**
	 * See also {@link HttpRestClient#withBaseUrl(String)}
	 *
	 * @param aBaseUrl The base url
	 * @return The HTTP rest client
	 * @throws MalformedURLException the malformed URL exception
	 */
	public static HttpRestClient withBaseUrl( String aBaseUrl ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().withBaseUrl( aBaseUrl );
	}

	/**
	 * See also {@link HttpRestClient#withBaseUrl(URL)}
	 *
	 * @param aBaseUrl The base url
	 * @return The HTTP rest client
	 */
	public static HttpRestClient withBaseUrl( URL aBaseUrl ) {
		return HttpRestClientSingleton.getInstance().withBaseUrl( aBaseUrl );
	}

	/**
	 * See also {@link HttpRestClient#withUserAgent(String)}
	 *
	 * @param aUserAgent The user agent
	 * @return The HTTP rest client
	 * @throws MalformedURLException the malformed URL exception
	 */
	public static HttpRestClient withUserAgent( String aUserAgent ) throws MalformedURLException {
		return HttpRestClientSingleton.getInstance().withUserAgent( aUserAgent );
	}

	// /////////////////////////////////////////////////////////////////////////
	// REQUEST BUILDER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aLocator );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aLocator );
	}

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also {@link HttpRestClient#doRequest(RestRequest)}
	 *
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( RestRequest aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, FormFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, FormFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, RequestHeaderFields)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, Object)}
	 *
	 * @param aLocator The locator
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String)}
	 *
	 * @param aLocator The locator
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aLocator ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aLocator );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, RequestHeaderFields, Object, RestResponseObserver)}
	 * *
	 * 
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, FormFields,RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aLocator, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, FormFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, RequestHeaderFields, RestResponseObserver)}
	 * *
	 * 
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aLocator, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aLocator, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aLocator, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aLocator, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aLocator, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, RestResponseObserver)}
	 *
	 * @param aLocator The locator
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aLocator, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aLocator, aResponseObserver );
	}

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL + HOST + PORT + PATH:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, int, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, int, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(Protocol, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, int, String, FormFields,RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 * 
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL + HOST + PATH:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, String, RequestHeaderFields, Object)}
	 * 
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, Protocol, String, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPost(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPut(Protocol, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(Protocol, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( Protocol aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, Protocol, String, String, FormFields,RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(Protocol, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(Protocol, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( Protocol aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(Protocol, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( Protocol aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(Protocol, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( Protocol aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aResponseObserver );
	}

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL (STRING) + HOST + PORT + PATH:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, int, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, int, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, int, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPort, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * 
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, String, int, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, int aPort, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, int, String, FormFields,RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, int, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPort The port
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, int aPort, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPort, aPath, aResponseObserver );
	}

	// /////////////////////////////////////////////////////////////////////////
	// PROTOCOL (STRING) + HOST + PATH:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildRequest(HttpMethod, String, String, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also {@link HttpRestClient#buildRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildRequest( aHttpMethod, aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildGet(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildGet(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildGet( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildGet( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPost(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPost(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPost( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPost( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildDelete(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildDelete(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildDelete( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#buildPut(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#buildPut(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest request builder
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestRequestBuilder buildPut( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().buildPut( aProtocol, aHost, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// SYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, Object)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doRequest(HttpMethod, String)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doGet(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doGet( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPost(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPost( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doDelete(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doDelete( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aRequest );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, RequestHeaderFields, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, String, String, FormFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, RequestHeaderFields)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, String, String, Object)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aRequest The request
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath, Object aRequest ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aRequest );
	}

	/**
	 * See also {@link HttpRestClient#doPut(String, String, String)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @return The rest response
	 * @throws HttpResponseException The HTTP response exception
	 */
	public static RestResponse doPut( String aProtocol, String aHost, String aPath ) throws HttpResponseException {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath );
	}

	// /////////////////////////////////////////////////////////////////////////
	// ASYNCHRONOUS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doRequest(HttpMethod, String, String, String, FormFields,RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aHttpMethod The HTTP method
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doRequest( HttpMethod aHttpMethod, String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doRequest( aHttpMethod, aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doGet(String, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doGet( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doGet( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPost(String, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPost( String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPost( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, RequestHeaderFields, RestResponseObserver)}
	 * *
	 * 
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doPut(String, String, String, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doPut( String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doPut( aProtocol, aHost, aPath, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, Object, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aBody The body
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, Object aBody, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aBody, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, FormFields, RequestHeaderFields, RestResponseObserver)}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aQueryFields The query fields
	 * @param aHeaderFields The Header-Fields
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, FormFields aQueryFields, RequestHeaderFields aHeaderFields, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aQueryFields, aHeaderFields, aResponseObserver );
	}

	/**
	 * See also
	 * {@link HttpRestClient#doDelete(String, String, String, RestResponseObserver)}}
	 *
	 * @param aProtocol The protocol
	 * @param aHost The host
	 * @param aPath The path
	 * @param aResponseObserver The response observer
	 * @return The rest caller builder
	 */
	public static RestCallerBuilder doDelete( String aProtocol, String aHost, String aPath, RestResponseObserver aResponseObserver ) {
		return HttpRestClientSingleton.getInstance().doDelete( aProtocol, aHost, aPath, aResponseObserver );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
