package org.refcodes.rest;

import java.io.File;

import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.net.BasicAuthObserver;
import org.refcodes.net.HttpMethod;
import org.refcodes.rest.impls.HttpRestServerSingleton;

/**
 * Declarative syntactic sugar which may be statically imported in order to
 * allow declarative definitions of RESTful server functionality:
 * 
 * <code>import static org.refcodes.rest.HttpRestServerSugar.*;</code>
 */
public class HttpRestServerSugar {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See {@link HttpRestServer#withBaseLocator(String)}.
	 *
	 * @param aBaseLocator The base locator
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer withBaseLocator( String aBaseLocator ) {
		return HttpRestServerSingleton.getInstance().withBaseLocator( aBaseLocator );
	}

	/**
	 * See {@link HttpRestServer#withRealm(String)}
	 *
	 * @param aRealm The realm
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer withRealm( String aRealm ) {
		return HttpRestServerSingleton.getInstance().withRealm( aRealm );
	}

	/**
	 * See {@link HttpRestServer#open(Object)}
	 *
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( int aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(Integer, int)}
	 *
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( int aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See
	 * {@link HttpRestServer#open(String, File, String, String, String, Integer, int)}
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStoreType The key store type
	 * @param aKeyStorePassword The key store password
	 * @param aKeyPassword The key password
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, File aKeyStoreFile, String aKeyStoreType, String aKeyStorePassword, String aKeyPassword, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aKeyStoreFile, aKeyStoreType, aKeyStorePassword, aKeyPassword, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See
	 * {@link HttpRestServer#open(String, File, String, String, String, Integer)}
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStoreType The key store type
	 * @param aKeyStorePassword The key store password
	 * @param aKeyPassword The key password
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, File aKeyStoreFile, String aKeyStoreType, String aKeyStorePassword, String aKeyPassword, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aKeyStoreFile, aKeyStoreType, aKeyStorePassword, aKeyPassword, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(String, File, String, Integer, int )}
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, File aKeyStoreFile, String aKeyStorePassword, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aKeyStoreFile, aKeyStorePassword, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(String, File, String, Integer )}
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, File aKeyStoreFile, String aKeyStorePassword, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aKeyStoreFile, aKeyStorePassword, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(File, String, Integer, int )}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( File aKeyStoreFile, String aKeyStorePassword, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aKeyStoreFile, aKeyStorePassword, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(File, String, Integer )}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( File aKeyStoreFile, String aKeyStorePassword, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aKeyStoreFile, aKeyStorePassword, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(File, String, String, Integer, int)}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aKeyPassword The key password
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( File aKeyStoreFile, String aKeyStorePassword, String aKeyPassword, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aKeyStoreFile, aKeyStorePassword, aKeyPassword, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(File, String, String, Integer, int)}
	 *
	 * @param aKeyStoreFile The key store file
	 * @param aKeyStorePassword The key store password
	 * @param aKeyPassword The key password
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException the open exception
	 */
	public static HttpRestServer open( File aKeyStoreFile, String aKeyStorePassword, String aKeyPassword, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aKeyStoreFile, aKeyStorePassword, aKeyPassword, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#close()}
	 *
	 * @return The {@link HttpRestServer}
	 * @throws CloseException the close exception
	 */
	public static HttpRestServer close() throws CloseException {
		HttpRestServerSingleton.getInstance().close();
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#closeIn(int)}
	 *
	 * @param aCloseInMillis The close in millis
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer closeIn( int aCloseInMillis ) {
		HttpRestServerSingleton.getInstance().closeIn( aCloseInMillis );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#closeQuietly()}
	 *
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer closeQuietly() {
		HttpRestServerSingleton.getInstance().closeQuietly();
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#onRequest(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onRequest( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onRequest( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See
	 * {@link HttpRestServer#onRequest(HttpMethod, String, RestRequestObserver)}
	 *
	 * @param aHttpMethod The HTTP-Method
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onRequest( HttpMethod aHttpMethod, String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onRequest( aHttpMethod, aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onGet(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onGet( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onGet( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onPut(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onPut( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onPut( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onPost(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder} See
	 *         {@link HttpRestServer#onPost(String, RestRequestObserver)}
	 */
	public static RestEndpointBuilder onPost( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onPost( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onDelete(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onDelete( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onDelete( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onBasicAuthRequest(BasicAuthObserver)}
	 *
	 * @param aObserver The observer
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer onBasicAuthRequest( BasicAuthObserver aObserver ) {
		return HttpRestServerSingleton.getInstance().onBasicAuthRequest( aObserver );
	}

	/**
	 * See {@link HttpRestServer#unsubscribeObserver(Object)}
	 *
	 * @param aEndpoint The endpoint
	 * @return true, if successful
	 */
	public static boolean unsubscribeObserver( RestEndpoint aEndpoint ) {
		return HttpRestServerSingleton.getInstance().unsubscribeObserver( aEndpoint );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
