// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

/**
 * Extends a {@link RestClient} to be used as loopback device e.g. for testing
 * purposes such as testing your {@link RestResponseObserver} implementations.
 * Register your custom {@link RestRequestHandler} with
 * {@link #onRestRequest(RestRequestHandler)} to simulate REST responses on the
 * {@link LoopbackRestClient}.
 */
public interface LoopbackRestClient extends RestClient {

	/**
	 * Registers a {@link RestRequestHandler} to simulate a REST response: The
	 * {@link RestRequestHandler#onRestRequest(org.refcodes.net.HttpClientRequest)}
	 * method is invoked with a prepared {@link RestCallerBuilder} instance
	 * representing the request being sent and produces an according
	 * {@link RestResponseEvent} to be passed back to the issuer of the request.
	 * 
	 * @param aHandler The {@link RestRequestHandler} for handling the HTTP
	 *        request and producing the {@link RestResponseEvent}.
	 */
	void onRestRequest( RestRequestHandler aHandler );

	/**
	 * With user agent.
	 *
	 * @param aUserAgent The user agent
	 * @return The loopback rest client
	 */
	@Override
	default LoopbackRestClient withUserAgent( String aUserAgent ) {
		setUserAgent( aUserAgent );
		return this;
	}
}
