package org.refcodes.rest;

import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.mixin.Dumpable;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerRequest;
import org.refcodes.net.LocalAddressAccessor;
import org.refcodes.net.RealmAccessor;
import org.refcodes.net.RemoteAddressAccessor;
import org.refcodes.observer.ActionEvent;

/**
 * Defines a {@link RestRequestEvent} being the request as consumed by a
 * {@link RestEndpoint}. Usually you will use
 * {@link RestServer#onRequest(HttpMethod, String, RestRequestObserver)} for
 * registering a {@link RestRequestObserver} to the {@link RestServer} (
 * {@link HttpRestServer}).
 */
public interface RestRequestEvent extends ActionEvent<HttpMethod, RestServer>, HttpServerRequest, WildcardSubstitutes, RemoteAddressAccessor, LocalAddressAccessor, RealmAccessor, Dumpable {

	/**
	 * Gets the action.
	 *
	 * @return the action
	 */
	@Override
	default HttpMethod getAction() {
		return getHttpMethod();
	}
}
