/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.impls.PortManagerSingleton;
import org.refcodes.rest.HttpRestClientSugar;
import org.refcodes.rest.HttpRestServerSugar;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestEndpointBuilder;
import org.refcodes.rest.RestResponse;

public class HttpRestSugarTest {
    private static final String BASE_URL = "http://localhost";
    private static final String BASE_LOCATOR = "/refcodes";
    private static final String LOCATOR = "/bla";
    private static final String LAST_NAME = "Bushnell";
    private static final String FIRST_NAME = "Nolan";
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchronousRestSugar() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServerSugar.withBaseLocator((String)BASE_LOCATOR);
        RestEndpointBuilder theObserver = HttpRestServerSugar.onPost((String)LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        });
        theObserver.open();
        HttpRestServerSugar.open((int)thePort);
        HttpRestClientSugar.withBaseUrl((String)this.toBaseUrl(thePort));
        HttpRestClientSugar.doPost((String)LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            LOGGER.debug(thePerson.toString());
            HttpRestServerSugar.closeQuietly();
            HttpRestSugarTest httpRestSugarTest = this;
            synchronized (httpRestSugarTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestSugarTest httpRestSugarTest = this;
        synchronized (httpRestSugarTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        HttpRestServerSugar.unsubscribeObserver((RestEndpoint)theObserver);
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Test
    public void testSynchronousRestSugar() throws IOException, HttpResponseException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServerSugar.withBaseLocator((String)BASE_LOCATOR);
        RestEndpointBuilder theObserver = HttpRestServerSugar.onPost((String)LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        });
        theObserver.open();
        HttpRestServerSugar.open((int)thePort);
        HttpRestClientSugar.withBaseUrl((String)this.toBaseUrl(thePort));
        RestResponse theResponse = HttpRestClientSugar.doPost((String)LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME));
        Person thePerson = (Person)theResponse.getResponse(Person.class);
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
        LOGGER.debug(thePerson.toString());
        HttpRestServerSugar.unsubscribeObserver((RestEndpoint)theObserver);
        HttpRestServerSugar.closeQuietly();
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    private String toBaseUrl(Integer thePort) {
        return "http://localhost:" + thePort + BASE_LOCATOR;
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

