package org.refcodes.rest;

import java.security.KeyStore;

import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.net.BasicAuthObserver;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerContext;
import org.refcodes.security.KeyStoreDescriptor;

/**
 * Declarative syntactic sugar which may be statically imported in order to
 * allow declarative definitions of RESTful server functionality:
 * 
 * <code>import static org.refcodes.rest.HttpRestServerSugar.*;</code>
 */
public class HttpRestServerSugar {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * See {@link HttpRestServer#close()}
	 *
	 * @return The {@link HttpRestServer}
	 * @throws CloseException the close exception
	 */
	public static HttpRestServer close() throws CloseException {
		HttpRestServerSingleton.getInstance().close();
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#closeIn(int)}
	 *
	 * @param aCloseInMillis The close in millis
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer closeIn( int aCloseInMillis ) {
		HttpRestServerSingleton.getInstance().closeIn( aCloseInMillis );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#closeQuietly()}
	 *
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer closeQuietly() {
		HttpRestServerSingleton.getInstance().closeQuietly();
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#onBasicAuthRequest(BasicAuthObserver)}
	 *
	 * @param aObserver The observer
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer onBasicAuthRequest( BasicAuthObserver aObserver ) {
		return HttpRestServerSingleton.getInstance().onBasicAuthRequest( aObserver );
	}

	/**
	 * See {@link HttpRestServer#onDelete(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onDelete( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onDelete( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onGet(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onGet( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onGet( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onPost(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder} See
	 *         {@link HttpRestServer#onPost(String, RestRequestObserver)}
	 */
	public static RestEndpointBuilder onPost( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onPost( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onPut(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onPut( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onPut( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See
	 * {@link HttpRestServer#onRequest(HttpMethod, String, RestRequestObserver)}
	 *
	 * @param aHttpMethod The HTTP-Method
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onRequest( HttpMethod aHttpMethod, String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onRequest( aHttpMethod, aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#onRequest(String, RestRequestObserver)}
	 *
	 * @param aLocatorPattern The locator pattern
	 * @param aRequestObserver The request observer
	 * @return The {@link RestEndpointBuilder}
	 */
	public static RestEndpointBuilder onRequest( String aLocatorPattern, RestRequestObserver aRequestObserver ) {
		return HttpRestServerSingleton.getInstance().onRequest( aLocatorPattern, aRequestObserver );
	}

	/**
	 * See {@link HttpRestServer#open(Object)}
	 *
	 * @param aCtx The context describing the parameters required to open the
	 *        connection.
	 * 
	 * @return The {@link HttpRestServer}
	 * 
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( HttpServerContext aCtx ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aCtx );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(int)}
	 *
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( int aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(int, int)}
	 *
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( int aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(KeyStoreDescriptor, int)}
	 *
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTP.
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( KeyStoreDescriptor aStoreDescriptor, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aStoreDescriptor, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(KeyStoreDescriptor, int, int )}
	 *
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTP.
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( KeyStoreDescriptor aStoreDescriptor, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aStoreDescriptor, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(String, KeyStoreDescriptor, int)}
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTP.
	 * @param aPort The port
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, KeyStoreDescriptor aStoreDescriptor, Integer aPort ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aStoreDescriptor, aPort );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#open(String, KeyStoreDescriptor, int, int)}.
	 *
	 * @param aSecureSocketProtocol The secure socket protocol
	 * @param aStoreDescriptor The store descriptor describing your
	 *        {@link KeyStore} required by HTTP.
	 * @param aPort The port
	 * @param aMaxConnections The max connections
	 * @return The {@link HttpRestServer}
	 * @throws OpenException thrown in case the open operation caused problems.
	 */
	public static HttpRestServer open( String aSecureSocketProtocol, KeyStoreDescriptor aStoreDescriptor, Integer aPort, int aMaxConnections ) throws OpenException {
		HttpRestServerSingleton.getInstance().open( aSecureSocketProtocol, aStoreDescriptor, aPort, aMaxConnections );
		return HttpRestServerSingleton.getInstance();
	}

	/**
	 * See {@link HttpRestServer#unsubscribeObserver(Object)}
	 *
	 * @param aEndpoint The endpoint
	 * @return true, if successful
	 */
	public static boolean unsubscribeObserver( RestEndpoint aEndpoint ) {
		return HttpRestServerSingleton.getInstance().unsubscribeObserver( aEndpoint );
	}

	/**
	 * See {@link HttpRestServer#withBaseLocator(String)}.
	 *
	 * @param aBaseLocator The base locator
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer withBaseLocator( String aBaseLocator ) {
		return HttpRestServerSingleton.getInstance().withBaseLocator( aBaseLocator );
	}

	/**
	 * See {@link HttpRestServer#withRealm(String)}
	 *
	 * @param aRealm The realm
	 * @return The {@link HttpRestServer}
	 */
	public static HttpRestServer withRealm( String aRealm ) {
		return HttpRestServerSingleton.getInstance().withRealm( aRealm );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
