// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

import org.refcodes.net.ApplicationFormFactory;
import org.refcodes.net.ApplicationJsonFactory;
import org.refcodes.net.ApplicationXmlFactory;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeFactory;
import org.refcodes.net.MediaTypeFactoryLookup.MutableMediaTypeFactoryLookup;
import org.refcodes.net.TextPlainFactory;
import org.refcodes.net.UserAgentAccessor.UserAgentBuilder;
import org.refcodes.net.UserAgentAccessor.UserAgentProperty;
import org.refcodes.runtime.RequestCorrelation;
import org.refcodes.runtime.SessionCorrelation;

/**
 * A client to send requests for communicating with a RESTful server such as the
 * {@link HttpRestServer}.
 * 
 * For marshaling and unmarshaling HTTP bodies you have to register the
 * according {@link MediaTypeFactory} instances being capable of handling the
 * according {@link MediaType} definitions. Examples for ready to use
 * {@link MediaTypeFactory} implementations are
 * 
 * <ul>
 * <li>{@link ApplicationJsonFactory},
 * <li>{@link ApplicationXmlFactory}
 * <li>{@link ApplicationFormFactory}
 * <li>{@link TextPlainFactory}
 * </ul>
 * 
 * Implementations of the {@link RestClient} interface, such as the
 * {@link HttpRestClientImpl}, are initialized with some common
 * {@link MediaTypeFactory} instances.
 * 
 * You may set an individual User-Agent via {@link #setUserAgent(String)}, not
 * setting it will result in the default User-Agent to be set as coded into the
 * {@link RestClient} implementations.
 */
public interface RestClient extends RestGetClient, RestPostClient, RestDeleteClient, RestPutClient, MutableMediaTypeFactoryLookup, UserAgentProperty, UserAgentBuilder<RestClient>, RequestCorrelation<RestClient>, SessionCorrelation<RestClient> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withUserAgent( String aUserAgent ) {
		setUserAgent( aUserAgent );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withSessionCorrelation( boolean hasSessionCorrelation ) {
		setSessionCorrelation( hasSessionCorrelation );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withEnableSessionCorrelation() {
		enableSessionCorrelation();
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withDisableSessionCorrelation() {
		disableSessionCorrelation();
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withRequestCorrelation( boolean hasRequestCorrelation ) {
		setRequestCorrelation( hasRequestCorrelation );
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withEnableRequestCorrelation() {
		enableRequestCorrelation();
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default RestClient withDisableRequestCorrelation() {
		disableRequestCorrelation();
		return this;
	}
}
