// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

/**
 * Provides an accessor for a status {@link RestRequestObserver} property.
 */
public interface StatusRequestObserverAccessor {

	/**
	 * Retrieves the status {@link RestRequestObserver} from the status
	 * {@link RestRequestObserver} property.
	 * 
	 * @return The status {@link RestRequestObserver} stored by the status
	 *         {@link RestRequestObserver} property.
	 */
	RestRequestObserver getStatusRequestObserver();

	/**
	 * Provides a mutator for a status {@link RestRequestObserver} property.
	 */
	public interface StatusRequestObserverMutator {

		/**
		 * Sets the status {@link RestRequestObserver} for the status
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aStatusRequestObserver The status {@link RestRequestObserver} to be
		 *        stored by the status {@link RestRequestObserver} property.
		 */
		void setStatusRequestObserver( RestRequestObserver aStatusRequestObserver );
	}

	/**
	 * Provides a builder method for a status {@link RestRequestObserver}
	 * property returning the builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface StatusRequestObserverBuilder<B extends StatusRequestObserverBuilder<B>> {

		/**
		 * Sets the status {@link RestRequestObserver} for the status
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aRequestObserver The status {@link RestRequestObserver} to be
		 *        stored by the status {@link RestRequestObserver} property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withStatusRequestObserver( RestRequestObserver aRequestObserver );
	}

	/**
	 * Provides a status {@link RestRequestObserver} property.
	 */
	public interface StatusRequestObserverProperty extends StatusRequestObserverAccessor, StatusRequestObserverMutator {}
}
