/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Port;
import org.refcodes.data.Scheme;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.BadRequestException;
import org.refcodes.net.HttpClientRequest;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.ResponseHeaderFieldsImpl;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.AbstractRestClient;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseImpl;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class HttpRestClientImpl
extends AbstractRestClient
implements HttpRestClient {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int PIPE_STREAM_BUFFER = 1024;
    private Url _baseUrl = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private TrustStoreDescriptor _storeDescriptor;

    public HttpRestClientImpl() {
        this.onRestRequest(new HttpRestRequestHandler());
    }

    public HttpRestClientImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
        this.onRestRequest(new HttpRestRequestHandler());
    }

    public void setBaseUrl(URL aBaseUrl) {
        this.setBaseUrl((Url)new UrlImpl(aBaseUrl));
    }

    public void setTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this._storeDescriptor = aStoreDescriptor;
    }

    public HttpRestClient withBaseUrl(Url aBaseUrl) {
        this.setBaseUrl(aBaseUrl);
        return null;
    }

    public HttpRestClient withBaseUrl(URL aBaseURL) {
        this.setBaseUrl(aBaseURL);
        return this;
    }

    public void close() throws CloseException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public Url getBaseUrl() {
        return this._baseUrl;
    }

    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    @Override
    public void open(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws OpenException {
        if (aStoreDescriptor == null) {
            aStoreDescriptor = this.getTrustStoreDescriptor();
        } else {
            this._storeDescriptor = aStoreDescriptor;
        }
        if (aBaseUrl == null) {
            aBaseUrl = this.getBaseUrl();
        } else {
            this._baseUrl = aBaseUrl;
        }
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new OpenException("The HTTP rest client is already open, close first before opening again!");
        }
        this._connectionStatus = ConnectionStatus.OPENED;
        if (aStoreDescriptor != null) {
            SystemProperty.TRUST_STORE_FILE.setValue(aStoreDescriptor.getStoreFile().getAbsolutePath());
            SystemProperty.TRUST_STORE_PASSWORD.setValue(aStoreDescriptor.getStorePassword() != null ? aStoreDescriptor.getStorePassword() : "");
            SystemProperty.TRUST_STORE_TYPE.setValue(aStoreDescriptor.getStoreType().name());
        }
    }

    public void setBaseUrl(Url aBaseUrl) {
        if (aBaseUrl != null) {
            if (aBaseUrl.getScheme() != Scheme.HTTP && aBaseUrl.getScheme() != Scheme.HTTPS) {
                throw new IllegalArgumentException("Cannot use the protocol <" + aBaseUrl.getScheme() + "> to do HTTP requests (" + aBaseUrl.toHttpUrl() + "). You must provide a base URL for protocols <" + Scheme.HTTP.getName() + "> or <" + Scheme.HTTPS.getName() + ">.");
            }
            if (aBaseUrl.getQueryFields() != null && aBaseUrl.getQueryFields().size() != 0) {
                throw new IllegalArgumentException("Cannot use a query <" + new VerboseTextBuilderImpl().withElements((Map)aBaseUrl.getQueryFields()) + "> as bayse path. You must provide a base URL without a query.");
            }
        }
        this._baseUrl = aBaseUrl;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    protected static void pipe(InputStream aInputStream, OutputStream aOutoutStream) throws IOException {
        int eBytes;
        byte[] theBuffer = new byte[1024];
        while ((eBytes = aInputStream.read(theBuffer)) > -1) {
            aOutoutStream.write(theBuffer, 0, eBytes);
        }
    }

    private static class HttpConnectionInputStream
    extends InputStream {
        private InputStream _inputStream;

        public HttpConnectionInputStream(HttpURLConnection aHttpURLConnection) {
            try {
                this._inputStream = aHttpURLConnection.getInputStream();
            }
            catch (IOException e) {
                String theMessage = e.getMessage();
                this._inputStream = new ByteArrayInputStream(theMessage.getBytes(StandardCharsets.UTF_8));
            }
        }

        @Override
        public int available() throws IOException {
            return this._inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this._inputStream.close();
        }

        public boolean equals(Object obj) {
            return this._inputStream.equals(obj);
        }

        public int hashCode() {
            return this._inputStream.hashCode();
        }

        @Override
        public void mark(int readlimit) {
            this._inputStream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this._inputStream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this._inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._inputStream.read(b, off, len);
        }

        @Override
        public void reset() throws IOException {
            this._inputStream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._inputStream.skip(n);
        }

        public String toString() {
            return this._inputStream.toString();
        }
    }

    private class HttpRestRequestHandler
    implements RestRequestHandler {
        private HttpRestRequestHandler() {
        }

        @Override
        public RestResponse onRestRequest(HttpClientRequest aClientRequest) throws HttpResponseException {
            if (HttpRestClientImpl.this._connectionStatus == ConnectionStatus.CLOSED) {
                throw new IllegalStateException(" Expected a connection status <" + ConnectionStatus.OPENED.name() + ">, unable to produce a HTTP request while the connection is in status <" + HttpRestClientImpl.this._connectionStatus.name() + ">, did you forget to call #open(...)?");
            }
            try {
                URL theUrl = null;
                try {
                    theUrl = aClientRequest.getUrl().toURL();
                }
                catch (MalformedURLException e) {
                    if (HttpRestClientImpl.this._baseUrl == null) {
                        throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, "Unable to create a valid URL from locator <" + aClientRequest.getUrl().toHttpUrl() + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    }
                    try {
                        String theExternalForm = HttpRestClientImpl.this._baseUrl.toHttpUrl();
                        String theRelativeUrl = aClientRequest.getUrl().toHttpUrl();
                        Object theSeparator = "";
                        if (!(theExternalForm != null && theExternalForm.endsWith("" + Delimiter.PATH.getChar()) || theRelativeUrl != null && theRelativeUrl.startsWith("" + Delimiter.PATH.getChar()))) {
                            theSeparator = "" + Delimiter.PATH.getChar();
                        }
                        theUrl = new URL(theExternalForm + (String)theSeparator + theRelativeUrl);
                    }
                    catch (MalformedURLException e2) {
                        throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, "Unable to create a valid URL from the base URL <" + HttpRestClientImpl.this._baseUrl.toHttpUrl() + "> and the locator <" + aClientRequest.getUrl().toHttpUrl() + ">: " + ExceptionUtility.toMessage((Throwable)e2), (Throwable)e2);
                    }
                }
                int thePort = theUrl.getPort();
                if (thePort == -1) {
                    String theProtocol = theUrl.getProtocol();
                    if (Scheme.HTTP.getName().equalsIgnoreCase(theProtocol)) {
                        thePort = Port.HTTP.getPort();
                    }
                    if (Scheme.HTTPS.getName().equalsIgnoreCase(theProtocol)) {
                        thePort = Port.HTTPS.getPort();
                    }
                }
                InetSocketAddress theRemoteAddress = new InetSocketAddress(theUrl.getHost(), thePort);
                InetSocketAddress theLocalAddress = InetSocketAddress.createUnresolved(InetAddress.getLocalHost().getHostName(), thePort);
                HttpURLConnection theHttpConnection = (HttpURLConnection)theUrl.openConnection();
                theHttpConnection.setRequestMethod(aClientRequest.getHttpMethod().name());
                List theAcceptTypes = ((RequestHeaderFields)aClientRequest.getHeaderFields()).getAcceptTypes();
                if (theAcceptTypes == null || theAcceptTypes.size() == 0) {
                    ((RequestHeaderFields)aClientRequest.getHeaderFields()).putAcceptTypes((HttpMediaType[])HttpRestClientImpl.this.getFactoryMediaTypes());
                }
                theHttpConnection.setRequestMethod(aClientRequest.getHttpMethod().name());
                HttpRestClientImpl.this.doRequestCorrelation((RequestHeaderFields)aClientRequest.getHeaderFields());
                HttpRestClientImpl.this.doSessionCorrelation((RequestHeaderFields)aClientRequest.getHeaderFields());
                for (String eKey : ((RequestHeaderFields)aClientRequest.getHeaderFields()).keySet()) {
                    theHttpConnection.setRequestProperty(eKey, ((RequestHeaderFields)aClientRequest.getHeaderFields()).toField(eKey));
                }
                Object theRequest = aClientRequest.getRequest();
                if (theRequest instanceof InputStream) {
                    InputStream theInputStream = (InputStream)theRequest;
                    theHttpConnection.setDoOutput(true);
                    HttpRestClientImpl.pipe(theInputStream, theHttpConnection.getOutputStream());
                    theHttpConnection.getOutputStream().flush();
                } else {
                    String theBody = aClientRequest.toHttpBody();
                    if (theBody != null) {
                        theHttpConnection.setDoOutput(true);
                        theHttpConnection.getOutputStream().write(theBody.getBytes());
                        theHttpConnection.getOutputStream().flush();
                    }
                }
                if (!aClientRequest.getHttpMethod().name().equalsIgnoreCase(theHttpConnection.getRequestMethod())) {
                    LOGGER.warn("You issued a request with HTTP-Method <" + aClientRequest.getHttpMethod().name() + "> which is not applicable for sending a HTTP body, the HTTP-Method has been changed to <" + theHttpConnection.getRequestMethod() + ">.");
                }
                ResponseHeaderFieldsImpl theResponseHeaderFields = new ResponseHeaderFieldsImpl();
                Map<String, List<String>> theHeaderFields = theHttpConnection.getHeaderFields();
                theResponseHeaderFields.putAll(theHeaderFields);
                HttpRestClientImpl.this.doRequestCorrelation((ResponseHeaderFields)theResponseHeaderFields);
                HttpRestClientImpl.this.doSessionCorrelation((ResponseHeaderFields)theResponseHeaderFields);
                HttpStatusCode theStatusCode = HttpStatusCode.toHttpStatusCode((int)theHttpConnection.getResponseCode());
                RestResponseImpl theResponse = new RestResponseImpl(theLocalAddress, theRemoteAddress, theStatusCode, (ResponseHeaderFields)theResponseHeaderFields, new HttpConnectionInputStream(theHttpConnection), (MediaTypeFactoryLookup)HttpRestClientImpl.this);
                return theResponse;
            }
            catch (IOException e) {
                throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, (Throwable)e, e.getMessage());
            }
            catch (BadRequestException e) {
                throw new HttpResponseException(e.getStatusCode(), (Throwable)e, e.getMessage());
            }
        }
    }
}

