/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.OpenException;
import org.refcodes.net.FormFields;
import org.refcodes.net.HeaderFields;
import org.refcodes.net.HeaderFieldsAccessor;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpMethodAccessor;
import org.refcodes.net.HttpRequestBuilder;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.Url;
import org.refcodes.net.UrlAccessor;
import org.refcodes.net.UrlBuilderImpl;
import org.refcodes.rest.RestCaller;
import org.refcodes.rest.RestResponseObserver;

public interface RestCallerBuilder
extends RestCaller,
HttpRequestBuilder<RestCallerBuilder>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestCallerBuilder>,
LinkComponent.LinkComponentBuilder<RestCallerBuilder>,
ConnectionStatusAccessor,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestCallerBuilder> {
    default public void setQueryFields(FormFields aQueryFields) {
        Url theUrl = this.getUrl();
        Object theUrlBuilder = theUrl instanceof UrlAccessor.UrlBuilder ? (Url.UrlBuilder)theUrl : new UrlBuilderImpl(theUrl);
        theUrlBuilder.setQueryFields(aQueryFields);
        this.setUrl((Url)theUrlBuilder);
    }

    default public FormFields getQueryFields() {
        return this.getUrl().getQueryFields();
    }

    default public RestCallerBuilder withUrl(Url aUrl) {
        this.setUrl(aUrl);
        return this;
    }

    default public RestCallerBuilder withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    default public <REQ> RestCallerBuilder withRequest(REQ aRequest) {
        this.setRequest(aRequest);
        return this;
    }

    public RestResponseObserver getResponseObserver();

    public void setResponseObserver(RestResponseObserver var1);

    default public RestCallerBuilder withResponseObserver(RestResponseObserver aLambda) {
        this.setResponseObserver(aLambda);
        return this;
    }

    default public RestCallerBuilder withHeaderFields(RequestHeaderFields aRequestHeaderFields) {
        this.setHeaderFields((HeaderFields)aRequestHeaderFields);
        return this;
    }

    default public RestCallerBuilder withOpen() throws OpenException {
        this.open();
        return this;
    }

    default public RestCallerBuilder withClose() throws CloseException {
        this.close();
        return this;
    }

    default public RestCallerBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    default public RestCallerBuilder withCloseIn(int aCloseInMillis) {
        this.closeIn(aCloseInMillis);
        return this;
    }
}

