/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.Map;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpClientRequestImpl;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.Url;
import org.refcodes.net.UrlAccessor;
import org.refcodes.net.UrlBuilderImpl;
import org.refcodes.rest.RestCallerBuilder;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.rest.RestResponseObserver;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class RestCallerBuilderImpl
extends HttpClientRequestImpl
implements RestCallerBuilder {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private RestResponseObserver _responseObserver = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestCallerBuilderImpl(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseObserver aResponseObserver, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, (Url)(aUrl instanceof UrlAccessor.UrlBuilder ? aUrl : new UrlBuilderImpl(aUrl)), aHeaderFields, aRequest, aMediaTypeFactoryLookup);
        this._responseObserver = aResponseObserver;
    }

    public RestCallerBuilderImpl(HttpMethod aHttpMethod, Url aUrl, RestResponseObserver aResponseObserver, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, null, aResponseObserver, aMediaTypeFactoryLookup);
    }

    public RestCallerBuilderImpl(HttpMethod aHttpMethod, Url aUrl, Object aRequest, RestResponseObserver aResponseObserver, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, aRequest, aResponseObserver, aMediaTypeFactoryLookup);
    }

    @Override
    public void onResponse(RestResponseEvent aResponse) throws HttpResponseException {
        if (this._connectionStatus != ConnectionStatus.CLOSED) {
            this._responseObserver.onResponse(aResponse);
        } else {
            LOGGER.warn("Ignoring response <" + aResponse + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may have closed it already?");
        }
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    @Override
    public RestResponseObserver getResponseObserver() {
        return this._responseObserver;
    }

    @Override
    public void setResponseObserver(RestResponseObserver aLambda) {
        this._responseObserver = aLambda;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws OpenException {
        this._connectionStatus = ConnectionStatus.OPENED;
        RestCallerBuilderImpl restCallerBuilderImpl = this;
        synchronized (restCallerBuilderImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CloseException {
        this._connectionStatus = ConnectionStatus.CLOSED;
        RestCallerBuilderImpl restCallerBuilderImpl = this;
        synchronized (restCallerBuilderImpl) {
            this.notifyAll();
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._httpMethod + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilderImpl().withElements((Map)this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    public void setHeaderFields(RequestHeaderFields aHeaderFields) {
        this._headerFields = aHeaderFields;
    }

    public Url getUrl() {
        return this._url;
    }

    public void setUrl(Url aUrl) {
        this._url = aUrl;
    }
}

