/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.exception.BugException;
import org.refcodes.net.BaseLocatorAccessor;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RealmAccessor;
import org.refcodes.observer.Observable;
import org.refcodes.observer.Observers;
import org.refcodes.rest.HttpExceptionHandlerAccessor;
import org.refcodes.rest.HttpExceptionHandlingAccessor;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestEndpointBuilder;
import org.refcodes.rest.RestEndpointBuilderImpl;
import org.refcodes.rest.RestRequestObserver;
import org.refcodes.runtime.RequestCorrelation;
import org.refcodes.runtime.SessionCorrelation;

public interface RestServer
extends HttpExceptionHandlerAccessor.HttpExceptionHandlerProperty,
HttpExceptionHandlerAccessor.HttpExceptionHandlerBuilder<RestServer>,
HttpExceptionHandlingAccessor.HttpExceptionHandlingProperty,
HttpExceptionHandlingAccessor.HttpExceptionHandlingBuilder<RestServer>,
Observable<RestEndpoint>,
Observers<RestEndpoint, RestServer>,
MediaTypeFactoryLookup.MutableMediaTypeFactoryLookup,
RealmAccessor.RealmProperty,
RealmAccessor.RealmBuilder<RestServer>,
BaseLocatorAccessor.BaseLocatorProperty,
BaseLocatorAccessor.BaseLocatorBuilder<RestServer>,
RequestCorrelation<RestServer>,
SessionCorrelation<RestServer> {
    default public RestServer withObserversActive(boolean isActive) {
        this.setObserversActive(isActive);
        return this;
    }

    default public RestServer withEnableObservers() {
        this.setObserversActive(true);
        return this;
    }

    default public RestServer withDisableObservers() {
        this.setObserversActive(false);
        return this;
    }

    default public RestServer withSessionCorrelation(boolean hasSessionCorrelation) {
        this.setSessionCorrelation(hasSessionCorrelation);
        return this;
    }

    default public RestServer withEnableSessionCorrelation() {
        this.enableSessionCorrelation();
        return this;
    }

    default public RestServer withDisableSessionCorrelation() {
        this.disableSessionCorrelation();
        return this;
    }

    default public RestServer withRequestCorrelation(boolean hasRequestCorrelation) {
        this.setRequestCorrelation(hasRequestCorrelation);
        return this;
    }

    default public RestServer withEnableRequestCorrelation() {
        this.enableRequestCorrelation();
        return this;
    }

    default public RestServer withDisableRequestCorrelation() {
        this.disableRequestCorrelation();
        return this;
    }

    default public boolean onRequest(RestEndpoint aRestEndpoint) {
        return this.subscribeObserver(aRestEndpoint);
    }

    default public RestServer withBaseLocator(String aBaseLocator) {
        this.setBaseLocator(aBaseLocator);
        return this;
    }

    default public RestServer withRealm(String aRealm) {
        this.setRealm(aRealm);
        return this;
    }

    default public RestEndpointBuilder onRequest(String aLocatorPattern, RestRequestObserver aRequestObserver) {
        return this.onRequest(null, aLocatorPattern, aRequestObserver);
    }

    default public RestEndpointBuilder onRequest(HttpMethod aHttpMethod, String aLocatorPattern, RestRequestObserver aRequestObserver) {
        RestEndpointBuilderImpl theEndpoint = new RestEndpointBuilderImpl(aHttpMethod, aLocatorPattern, aRequestObserver);
        if (!this.subscribeObserver(theEndpoint)) {
            throw new BugException("We encountered a bug! As we created the endpoint within this method, it cannot have been added already!");
        }
        return theEndpoint;
    }

    default public RestEndpointBuilder onGet(String aLocatorPattern, RestRequestObserver aRequestObserver) {
        return this.onRequest(HttpMethod.GET, aLocatorPattern, aRequestObserver);
    }

    default public RestEndpointBuilder onPut(String aLocatorPattern, RestRequestObserver aRequestObserver) {
        return this.onRequest(HttpMethod.PUT, aLocatorPattern, aRequestObserver);
    }

    default public RestEndpointBuilder onPost(String aLocatorPattern, RestRequestObserver aRequestObserver) {
        return this.onRequest(HttpMethod.POST, aLocatorPattern, aRequestObserver);
    }

    default public RestEndpointBuilder onDelete(String aLocatorPattern, RestRequestObserver aRequestObserver) {
        return this.onRequest(HttpMethod.DELETE, aLocatorPattern, aRequestObserver);
    }
}

