/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.net.HttpMethod;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.HttpRestServerImpl;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.security.KeyStoreDescriptorBuilderImpl;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorBuilderImpl;

public class HttpsRestServerTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String LOCATOR = "/bla";
    private static final String BASE_URL = "https://localhost:5161/refcodes";
    private static final String BASE_LOCATOR = "/refcodes";
    private static final String LAST_NAME = "Bushnell";
    private static final String FIRST_NAME = "Nolan";
    private static final String KEY_STORE_A = "keystore_a.jks";
    private static final String KEY_STORE_A_PASSWORD = "keyStoreSecret";
    private static final String KEY_A_PASSWORD = "keySecret";
    private static final String KEY_STORE_B = "keystore_b.jks";
    private static final String KEY_STORE_B_PASSWORD = "keyStoreSecret";
    private boolean _hasConnectionRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsRestServerA() throws IOException, URISyntaxException {
        this._hasConnectionRequest = false;
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assertions.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assertions.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.onConnectionRequest((aLocalAddress, aRemoteAddress, aHttpsParams) -> {
            if (IS_LOG_TESTS) {
                System.out.println("Local := " + aLocalAddress + ", remote := " + aRemoteAddress + ", HTTP params := " + aHttpsParams);
            }
            if (this._hasConnectionRequest) {
                Assertions.fail((String)"Expecting just one connection request.");
            }
            this._hasConnectionRequest = true;
        });
        theRestServer.open((KeyStoreDescriptor)new KeyStoreDescriptorBuilderImpl(this.toResourceFile(KEY_STORE_A), "keyStoreSecret", KEY_A_PASSWORD), 5161);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(BASE_URL);
        theRestClient.open((TrustStoreDescriptor)new TrustStoreDescriptorBuilderImpl(this.toResourceFile(KEY_STORE_A), "keyStoreSecret"));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            if (IS_LOG_TESTS) {
                System.out.println(thePerson.toString());
            }
            theRestServer.closeQuietly();
            HttpsRestServerTest httpsRestServerTest = this;
            synchronized (httpsRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpsRestServerTest httpsRestServerTest = this;
        synchronized (httpsRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((boolean)this._hasConnectionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="Either the one or the other test can be executed in a JVM instance.")
    public void testHttpsRestServerB() throws IOException, URISyntaxException {
        this._hasConnectionRequest = false;
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assertions.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assertions.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.onConnectionRequest((aLocalAddress, aRemoteAddress, aHttpsParams) -> {
            if (IS_LOG_TESTS) {
                System.out.println("Local := " + aLocalAddress + ", remote := " + aRemoteAddress + ", HTTP params := " + aHttpsParams);
            }
            if (this._hasConnectionRequest) {
                Assertions.fail((String)"Expecting just one connection request.");
            }
            this._hasConnectionRequest = true;
        });
        theRestServer.open((KeyStoreDescriptor)new KeyStoreDescriptorBuilderImpl(this.toResourceFile(KEY_STORE_B), "keyStoreSecret"), 5161);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(BASE_URL);
        theRestClient.open((TrustStoreDescriptor)new TrustStoreDescriptorBuilderImpl(this.toResourceFile(KEY_STORE_B)));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            if (IS_LOG_TESTS) {
                System.out.println(thePerson.toString());
            }
            theRestServer.closeQuietly();
            HttpsRestServerTest httpsRestServerTest = this;
            synchronized (httpsRestServerTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpsRestServerTest httpsRestServerTest = this;
        synchronized (httpsRestServerTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((boolean)this._hasConnectionRequest);
    }

    protected File toResourceFile(String aKeystoreFile) throws URISyntaxException {
        return new File(HttpsRestServerTest.class.getResource("/" + aKeystoreFile).toURI());
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

