// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.rest;

/**
 * The singleton of the {@link LoopbackRestClientImpl} for easy
 * {@link LoopbackRestClientImpl} access.
 */
public class LoopbackRestClientSingleton extends LoopbackRestClientImpl {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private static LoopbackRestClientSingleton _loopbackRestClientSingleton;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new loopback rest client singleton.
	 */
	protected LoopbackRestClientSingleton() {}

	/**
	 * Returns the singleton's instance as fabricated by this
	 * {@link LoopbackRestClientSingleton}.
	 * 
	 * @return The {@link LoopbackRestClientImpl} singleton's instance.
	 */
	public static LoopbackRestClient getInstance() {
		if ( _loopbackRestClientSingleton == null ) {
			synchronized ( LoopbackRestClientSingleton.class ) {
				_loopbackRestClientSingleton = new LoopbackRestClientSingleton();
			}
		}
		return _loopbackRestClientSingleton;
	}
}
