// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.rest;

/**
 * Provides an accessor for a ping {@link RestRequestObserver} property.
 */
public interface PingRequestObserverAccessor {

	/**
	 * Retrieves the ping {@link RestRequestObserver} from the ping
	 * {@link RestRequestObserver} property.
	 * 
	 * @return The ping {@link RestRequestObserver} stored by the ping
	 *         {@link RestRequestObserver} property.
	 */
	RestRequestObserver getPingRequestObserver();

	/**
	 * Provides a mutator for a ping {@link RestRequestObserver} property.
	 */
	public interface PingRequestObserverMutator {

		/**
		 * Sets the ping {@link RestRequestObserver} for the ping
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aPingRequestObserver The ping {@link RestRequestObserver} to
		 *        be stored by the ping {@link RestRequestObserver} property.
		 */
		void setPingRequestObserver( RestRequestObserver aPingRequestObserver );
	}

	/**
	 * Provides a builder method for a ping {@link RestRequestObserver} property
	 * returning the builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface PingRequestObserverBuilder<B extends PingRequestObserverBuilder<B>> {

		/**
		 * Sets the ping {@link RestRequestObserver} for the ping
		 * {@link RestRequestObserver} property.
		 * 
		 * @param aRequestObserver The ping {@link RestRequestObserver} to be
		 *        stored by the ping {@link RestRequestObserver} property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withPingRequestObserver( RestRequestObserver aRequestObserver );
	}

	/**
	 * Provides a ping {@link RestRequestObserver} property.
	 */
	public interface PingRequestObserverProperty extends PingRequestObserverAccessor, PingRequestObserverMutator {}
}
