/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ThreadingModel;
import org.refcodes.data.Delimiter;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.exception.BugException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.MarshalException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.AuthType;
import org.refcodes.net.BadResponseException;
import org.refcodes.net.BasicAuthCredentials;
import org.refcodes.net.BasicAuthCredentialsImpl;
import org.refcodes.net.BasicAuthObserver;
import org.refcodes.net.BasicAuthRequiredException;
import org.refcodes.net.BasicAuthResponse;
import org.refcodes.net.ContentType;
import org.refcodes.net.HeaderField;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.HttpBodyMapImpl;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpServerResponseImpl;
import org.refcodes.net.HttpStatusCode;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.HttpsConnectionRequestObserver;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeFactoryLookup;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.RequestHeaderFieldsImpl;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.TransportLayerProtocol;
import org.refcodes.net.UnsupportedMediaTypeException;
import org.refcodes.net.Url;
import org.refcodes.net.UrlBuilderImpl;
import org.refcodes.rest.AbstractRestServer;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestRequestEventImpl;
import org.refcodes.security.KeyStoreDescriptor;

public class HttpRestServerImpl
extends AbstractRestServer
implements HttpRestServer {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected static final String CONTEXT_PATH = Delimiter.PATH.getChar() + "";
    private static final String ANONYMOUS = "anonymous";
    private static final int NO_RESPONSE_BODY = -1;
    private static final int CHUNCKED_ENCODING = 0;
    private HttpServer _httpServer = null;
    private int _port = -1;
    private HttpsConnectionRequestObserver _httpsConnectionRequestObserver = null;
    private ExecutorService _executorService;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private HttpBasicAuthenticator _httpBasicAuthenticator = null;
    private HttpContext _httpContext;
    private Scheme _scheme = null;
    private String _protocol = null;
    private KeyStoreDescriptor _keyStoreDescriptor = null;
    private int _maxConnections = -1;

    public HttpRestServerImpl(ThreadingModel aThreadingModel) {
        this(aThreadingModel == ThreadingModel.SINGLE ? null : ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    public HttpRestServerImpl() {
        this(ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    public HttpRestServerImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
        this._executorService = aExecutorService;
        this._httpExceptionHandler = new DefaultErrorHandler();
    }

    public synchronized void close() throws CloseException {
        if (this._connectionStatus != ConnectionStatus.OPENED) {
            throw new CloseException("Connection is in status <" + this._connectionStatus + ">. Open the connection before closing!");
        }
        try {
            if (this._httpServer != null) {
                this._httpServer.stop(LatencySleepTime.MIN.getMilliseconds() / 1000);
                this._httpServer.removeContext(CONTEXT_PATH);
                this._httpServer = null;
            }
        }
        finally {
            this._connectionStatus = ConnectionStatus.CLOSED;
        }
    }

    @Override
    public void open(String aProtocol, KeyStoreDescriptor aStoreDescriptor, int aPort, int aMaxConnections) throws OpenException {
        Scheme theScheme;
        if (aPort < 0) {
            aPort = this.getPort();
        }
        if (aPort < 0) {
            throw new OpenException("You must provide a valid port via 'setPort( aPort )' before you can invoke a port-less 'open' method!");
        }
        this._port = aPort;
        if (aProtocol == null) {
            aProtocol = this.toProtocol();
        }
        if ((theScheme = Scheme.fromProtocol((String)aProtocol)) == Scheme.HTTPS) {
            aProtocol = TransportLayerProtocol.TLS.name();
        }
        if (aProtocol == null && aStoreDescriptor != null) {
            aProtocol = TransportLayerProtocol.TLS.name();
        }
        if (aStoreDescriptor == null) {
            aStoreDescriptor = this.getKeyStoreDescriptor();
        }
        if (aMaxConnections < 0) {
            aMaxConnections = this.getMaxConnections();
        }
        if (theScheme == null && aProtocol == null || theScheme == Scheme.HTTP) {
            try {
                HttpServer theHttpServer = HttpServer.create();
                theHttpServer.bind(new InetSocketAddress(aPort), aMaxConnections);
                this.open(theHttpServer);
            }
            catch (IOException e) {
                throw new OpenException("Unable to bind to port <" + aPort + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            }
        }
        try {
            InetSocketAddress theAddress = new InetSocketAddress(aPort);
            SSLContext theSSLContext = SSLContext.getInstance(aProtocol);
            KeyStore theKeyStore = KeyStore.getInstance(aStoreDescriptor.getStoreType().name());
            FileInputStream theKeystoreInputStream = new FileInputStream(aStoreDescriptor.getStoreFile());
            theKeyStore.load(theKeystoreInputStream, aStoreDescriptor.getStorePassword().toCharArray());
            KeyManagerFactory theKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            theKeyManagerFactory.init(theKeyStore, aStoreDescriptor.getKeyPassword().toCharArray());
            TrustManagerFactory theTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            theTrustManagerFactory.init(theKeyStore);
            theSSLContext.init(theKeyManagerFactory.getKeyManagers(), theTrustManagerFactory.getTrustManagers(), null);
            HttpsServer theHttpsServer = HttpsServer.create(theAddress, aMaxConnections);
            theHttpsServer.setHttpsConfigurator(new HttpsRestConfigurator(theSSLContext));
            theHttpsServer.setExecutor(null);
            this.open(theHttpsServer);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new OpenException("Unable to bind to port <" + aPort + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public HttpRestServer onConnectionRequest(HttpsConnectionRequestObserver aObserver) {
        this._httpsConnectionRequestObserver = aObserver;
        return this;
    }

    public HttpRestServer onBasicAuthRequest(BasicAuthObserver aBasicAuthObserver) {
        HttpContext theHttpContext = this._httpContext;
        HttpBasicAuthenticator theHttpBasicAuthenticator = null;
        if (aBasicAuthObserver != null) {
            theHttpBasicAuthenticator = new HttpBasicAuthenticator(aBasicAuthObserver);
            if (theHttpContext != null) {
                theHttpContext.setAuthenticator(theHttpBasicAuthenticator);
            }
        }
        this._httpBasicAuthenticator = theHttpBasicAuthenticator;
        return this;
    }

    @Override
    public HttpRestServer withRealm(String aRealm) {
        this.setRealm(aRealm);
        return this;
    }

    public void setPort(int aPort) {
        this._port = aPort;
    }

    public int getPort() {
        return this._port;
    }

    public void setScheme(Scheme aScheme) {
        this._scheme = aScheme;
        this._protocol = null;
    }

    public Scheme getScheme() {
        return this._scheme;
    }

    public String toProtocol() {
        if (this._scheme != null) {
            return this._scheme.toProtocol();
        }
        return this._protocol;
    }

    public void setProtocol(String aProtocol) {
        Scheme theScheme = Scheme.fromProtocol((String)aProtocol);
        if (theScheme != null) {
            this._scheme = theScheme;
            this._protocol = null;
        } else {
            this._protocol = aProtocol;
            this._scheme = null;
        }
    }

    public KeyStoreDescriptor getKeyStoreDescriptor() {
        return this._keyStoreDescriptor;
    }

    public void setKeyStoreDescriptor(KeyStoreDescriptor aStoreDescriptor) {
        this._keyStoreDescriptor = aStoreDescriptor;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int aMaxConnections) {
        this._maxConnections = aMaxConnections;
    }

    protected HttpServer getHttpServer() {
        return this._httpServer;
    }

    protected void open(HttpServer aHttpServer) throws IOException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new OpenException("Connection is still in status <" + this._connectionStatus + ">. Close the connection before reopening!");
        }
        if (this._executorService != null) {
            aHttpServer.setExecutor(this._executorService);
        }
        HttpContext theHttpContext = aHttpServer.createContext(CONTEXT_PATH, new EndpointHttpHandler());
        HttpBasicAuthenticator theHttpBasicAuthenticator = this._httpBasicAuthenticator;
        if (theHttpBasicAuthenticator != null) {
            theHttpContext.setAuthenticator(theHttpBasicAuthenticator);
        }
        aHttpServer.start();
        this._httpServer = aHttpServer;
        this._httpContext = theHttpContext;
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    private Authenticator.Result toBasicAuthFailure(HttpExchange aHttpExchange) {
        return new Authenticator.Failure(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private Authenticator.Success toBasicOutSuccess(String aIdentity) {
        return new Authenticator.Success(new HttpPrincipal(aIdentity, this.getRealm()));
    }

    private Authenticator.Result toBasicAuthRequired(HttpExchange aHttpExchange) {
        Headers theHeaders = aHttpExchange.getResponseHeaders();
        this.doBasicAuthRequired(theHeaders);
        return new Authenticator.Retry(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private void doBasicAuthRequired(Headers aHeaders) {
        aHeaders.set(HeaderField.WWW_AUTHENTICATE.getName(), "Basic realm=\"" + this.getRealm() + "\"");
    }

    private class HttpsRestConfigurator
    extends HttpsConfigurator {
        public HttpsRestConfigurator(SSLContext aSSLContext) {
            super(aSSLContext);
        }

        @Override
        public void configure(HttpsParameters aHttpsParams) {
            HttpsConnectionRequestObserver theObserver = HttpRestServerImpl.this._httpsConnectionRequestObserver;
            if (theObserver != null) {
                InetSocketAddress theRemoteAddress = aHttpsParams.getClientAddress();
                InetSocketAddress theLocalAddress = null;
                HttpServer theServer = HttpRestServerImpl.this.getHttpServer();
                if (theServer != null) {
                    theLocalAddress = theServer.getAddress();
                } else {
                    LOGGER.warn("Unable to determine the local address for remote address <" + theRemoteAddress.toString() + ">, the server might have been closed in the meantimne.");
                }
                SSLContext theSSLContext = this.getSSLContext();
                SSLParameters theSSLParams = theSSLContext.getDefaultSSLParameters();
                theObserver.onHttpsConnectionRequest(theLocalAddress, theRemoteAddress, theSSLParams);
                aHttpsParams.setSSLParameters(theSSLParams);
            }
        }
    }

    private class DefaultErrorHandler
    implements HttpExceptionHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void onHttpError(RestRequestEvent aRequestEvent, HttpServerResponse aHttpServerResponse, Exception aException, HttpStatusCode aHttpStatusCode) {
            switch (HttpRestServerImpl.this.getHttpExceptionHandling()) {
                case EMPTY: {
                    aHttpServerResponse.setResponse(null);
                    ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).clear();
                    break;
                }
                case KEEP: {
                    break;
                }
                case MERGE: {
                    HttpBodyMap theBodyMap = this.toResponseBodyMap(aHttpServerResponse);
                    if (!theBodyMap.hasStatusCode()) {
                        theBodyMap.putStatusCode(aHttpStatusCode);
                    }
                    if (!theBodyMap.hasStatusAlias()) {
                        theBodyMap.putStatusAlias(aHttpStatusCode);
                    }
                    if (!theBodyMap.hasStatusException()) {
                        theBodyMap.putStatusException(aException);
                    }
                    if (!theBodyMap.hasStatusMessage() && aException.getMessage() != null && aException.getMessage().length() > 0) {
                        theBodyMap.putStatusMessage(aException.getMessage());
                    }
                    if (!theBodyMap.hasStatusTimeStamp()) {
                        theBodyMap.putStatusTimeStamp();
                    }
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                case UPDATE: {
                    HttpBodyMap theBodyMap = this.toResponseBodyMap(aHttpServerResponse);
                    theBodyMap.putStatusCode(aHttpStatusCode);
                    theBodyMap.putStatusAlias(aHttpStatusCode);
                    theBodyMap.putStatusException(aException);
                    theBodyMap.putStatusMessage(aException.getMessage());
                    theBodyMap.putStatusTimeStamp();
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                case REPLACE: {
                    HttpBodyMapImpl theBodyMap = new HttpBodyMapImpl();
                    theBodyMap.putStatusCode(aHttpStatusCode);
                    theBodyMap.putStatusAlias(aHttpStatusCode);
                    theBodyMap.putStatusException(aException);
                    theBodyMap.putStatusMessage(aException.getMessage());
                    theBodyMap.putStatusTimeStamp();
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                default: {
                    throw new BugException("Missing case statement for <" + (Object)((Object)HttpRestServerImpl.this.getHttpExceptionHandling()) + "> in implementation!");
                }
            }
        }

        protected HttpBodyMap toResponseBodyMap(HttpServerResponse aHttpServerResponse) {
            HttpBodyMap theHttpBodyMap = null;
            Object theResponse = aHttpServerResponse.getResponse();
            if (theResponse != null) {
                if (theResponse instanceof HttpBodyMap) {
                    theHttpBodyMap = (HttpBodyMap)theResponse;
                } else if (!(theResponse instanceof InputStream)) {
                    theHttpBodyMap = new HttpBodyMapImpl(aHttpServerResponse.getResponse());
                }
            }
            if (theHttpBodyMap == null) {
                theHttpBodyMap = new HttpBodyMapImpl();
            }
            return theHttpBodyMap;
        }
    }

    private class EndpointHttpHandler
    implements HttpHandler {
        private EndpointHttpHandler() {
        }

        @Override
        public void handle(HttpExchange aHttpExchange) throws IOException {
            HttpMethod theHttpMethod = HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod());
            if (theHttpMethod != null) {
                URI theRequestURI = aHttpExchange.getRequestURI();
                HttpServerResponseImpl theHttpServerResponse = new HttpServerResponseImpl((MediaTypeFactoryLookup)HttpRestServerImpl.this);
                InetSocketAddress theLocalAddress = aHttpExchange.getLocalAddress();
                InetSocketAddress theRemoteAddress = aHttpExchange.getRemoteAddress();
                Headers theRequestHeaders = aHttpExchange.getRequestHeaders();
                RequestHeaderFieldsImpl theRequestHeaderFields = new RequestHeaderFieldsImpl((Map)theRequestHeaders);
                UrlBuilderImpl theUrl = new UrlBuilderImpl(theRequestURI.toString());
                if (theUrl.getScheme() == null) {
                    Scheme theScheme = HttpRestServerImpl.this._scheme;
                    if (theScheme == null) {
                        theScheme = TransportLayerProtocol.toScheme((String)HttpRestServerImpl.this._protocol);
                    }
                    theUrl.setScheme(theScheme);
                }
                if (theUrl.getHost() == null) {
                    theUrl.setHost(Literal.LOCALHOST.getName());
                }
                if (theUrl.getPort() == -1) {
                    theUrl.setPort(HttpRestServerImpl.this._port);
                }
                try {
                    this.onHttpRequest(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, (Url.UrlBuilder)theUrl, (RequestHeaderFields)theRequestHeaderFields, aHttpExchange.getRequestBody(), (HttpServerResponse)theHttpServerResponse);
                }
                catch (BasicAuthRequiredException e) {
                    HttpRestServerImpl.this.doBasicAuthRequired(aHttpExchange.getResponseHeaders());
                    LOGGER.info("Required HTTP Basic-Authentication with status <" + e.getStatusCode() + "> with code <" + e.getStatusCode().getStatusCode() + "> for request URL <" + theRequestURI + "> with request method <" + aHttpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)e));
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, (Url.UrlBuilder)theUrl, (RequestHeaderFields)theRequestHeaderFields, (HttpServerResponse)theHttpServerResponse, (Exception)((Object)e), e.getStatusCode());
                }
                catch (HttpStatusException e) {
                    LOGGER.warn("Responding status <" + e.getStatusCode() + "> with code <" + e.getStatusCode().getStatusCode() + "> for request URL <" + theRequestURI + "> with request method <" + aHttpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)e));
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, (Url.UrlBuilder)theUrl, (RequestHeaderFields)theRequestHeaderFields, (HttpServerResponse)theHttpServerResponse, (Exception)((Object)e), e.getStatusCode());
                }
                catch (Exception e) {
                    LOGGER.warn("Bad request <" + e.getClass().getName() + "> for request URL <" + theRequestURI + "> with request method <" + aHttpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, (Url.UrlBuilder)theUrl, (RequestHeaderFields)theRequestHeaderFields, (HttpServerResponse)theHttpServerResponse, e, HttpStatusCode.BAD_REQUEST);
                }
            } else {
                LOGGER.warn("Unknown HTTP-Method <" + aHttpExchange.getRequestMethod() + "> when querying resource locator <" + aHttpExchange.getLocalAddress() + ">.");
                aHttpExchange.sendResponseHeaders(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), -1L);
            }
        }

        private void onHttpRequest(HttpExchange aHttpExchange, InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url.UrlBuilder aUrl, RequestHeaderFields aRequestHeaderFields, InputStream aHttpInputStream, HttpServerResponse aHttpServerResponse) throws HttpStatusException, MarshalException, IOException {
            HttpRestServerImpl.super.onHttpRequest(aLocalAddress, aRemoteAddress, aHttpMethod, (Url)aUrl, aRequestHeaderFields, aHttpInputStream, aHttpServerResponse);
            HttpStatusCode theHttpStatusCode = aHttpServerResponse.getHttpStatusCode();
            if (theHttpStatusCode == null) {
                theHttpStatusCode = HttpStatusCode.OK;
            }
            this.doHttpResponse(aHttpExchange, aRequestHeaderFields, aHttpServerResponse, theHttpStatusCode);
        }

        protected void onHttpException(HttpExchange aHttpExchange, InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url.UrlBuilder aUrl, RequestHeaderFields aRequestHeaderFields, HttpServerResponse aHttpServerResponse, Exception aException, HttpStatusCode aHttpStatusCode) throws IOException {
            aHttpServerResponse.setHttpStatusCode(aHttpStatusCode);
            if (HttpRestServerImpl.this._httpExceptionHandler != null) {
                try {
                    RestRequestEventImpl theRestRequestEvent = new RestRequestEventImpl(aLocalAddress, aRemoteAddress, aHttpMethod, (Url)aUrl, null, aRequestHeaderFields, aHttpExchange.getRequestBody(), HttpRestServerImpl.this);
                    HttpRestServerImpl.this._httpExceptionHandler.onHttpError(theRestRequestEvent, aHttpServerResponse, aException, aHttpStatusCode);
                    this.finalizeMediaType(aHttpServerResponse);
                    this.doHttpResponse(aHttpExchange, aRequestHeaderFields, aHttpServerResponse, aHttpStatusCode);
                }
                catch (Exception failed) {
                    this.finalizeHttpExceptionResponse(aHttpExchange, aException, aHttpStatusCode);
                }
            } else {
                this.finalizeHttpExceptionResponse(aHttpExchange, aException, aHttpStatusCode);
            }
        }

        protected void finalizeMediaType(HttpServerResponse aHttpServerResponse) {
            ContentType theContentType;
            if (!(aHttpServerResponse.getResponse() == null || (theContentType = ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).getContentType()) != null && HttpRestServerImpl.this.hasMediaTypeFactory(theContentType.getMediaType()))) {
                String theTypeText = theContentType != null ? theContentType.toHttpMediaType() : null;
                LOGGER.warn("Unsupported Content-Type <" + theTypeText + "> detected in HTTP-Server-Response, trying fallback ...");
                if (HttpRestServerImpl.this.getFactoryMediaTypes().length == 0) {
                    LOGGER.warn("No fallback Content-Type detected for HTTP-Server-Response as no Media-Type-Factories have been configured ...");
                } else if (HttpRestServerImpl.this.getFactoryMediaTypes().length != 0) {
                    MediaType theMediaType = HttpRestServerImpl.this.getFactoryMediaTypes()[0];
                    LOGGER.info("Using fallback Content-Type <" + theMediaType.toHttpMediaType() + "> for HTTP-Server-Response ...");
                    ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).putContentType((HttpMediaType)theMediaType);
                }
            }
        }

        protected void doHttpResponse(HttpExchange aHttpExchange, RequestHeaderFields aRequestHeaderFields, HttpServerResponse aHttpServerResponse, HttpStatusCode aHttpStatusCode) throws IOException, MarshalException, UnsupportedMediaTypeException {
            Headers theResponseHeaders = aHttpExchange.getResponseHeaders();
            for (String eKey : ((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).keySet()) {
                theResponseHeaders.put(eKey, (List)((ResponseHeaderFields)aHttpServerResponse.getHeaderFields()).get((Object)eKey));
            }
            Object theResponse = aHttpServerResponse.getResponse();
            if (theResponse instanceof InputStream) {
                aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), 0L);
                InputStream theInputStream = (InputStream)theResponse;
                HttpRestClientImpl.pipe(theInputStream, aHttpExchange.getResponseBody());
                aHttpExchange.getResponseBody().flush();
            } else {
                byte[] theBytes = null;
                if (theResponse != null) {
                    try {
                        theBytes = aHttpServerResponse.toHttpBody().getBytes();
                    }
                    catch (BadResponseException e) {
                        LOGGER.warn(e.getMessage() + ": Trying fallback procedure ...");
                        theBytes = HttpRestServerImpl.this.toResponseBody(aHttpServerResponse.getResponse(), aRequestHeaderFields, (ResponseHeaderFields)aHttpServerResponse.getHeaderFields());
                    }
                }
                if (theBytes != null && theBytes.length != 0) {
                    aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), theBytes.length);
                    aHttpExchange.getResponseBody().write(theBytes);
                    aHttpExchange.getResponseBody().flush();
                } else {
                    aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), -1L);
                }
            }
            aHttpExchange.getResponseBody().close();
        }

        protected void finalizeHttpExceptionResponse(HttpExchange aHttpExchange, Exception aException, HttpStatusCode aHttpStatusCode) throws IOException {
            LOGGER.warn("Unable fully satisfy <" + (Object)((Object)HttpRestServerImpl.this.getHttpExceptionHandling()) + "> mode, falling back to <" + (Object)((Object)HttpExceptionHandling.EMPTY) + "> : " + aException.getMessage(), (Throwable)aException);
            aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), -1L);
            aHttpExchange.getResponseBody().close();
        }
    }

    private class HttpBasicAuthenticator
    extends Authenticator {
        private BasicAuthObserver _basicAuthObserver;

        public HttpBasicAuthenticator(BasicAuthObserver aBasicAuthObserver) {
            this._basicAuthObserver = aBasicAuthObserver;
        }

        @Override
        public Authenticator.Result authenticate(HttpExchange aHttpExchange) {
            Headers theRequestHeaders = aHttpExchange.getRequestHeaders();
            String theAuthHeader = theRequestHeaders.getFirst(HeaderField.AUTHORIZATION.getName());
            BasicAuthCredentialsImpl theCredentials = null;
            if (theAuthHeader == null) {
                BasicAuthResponse theBasicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(aHttpExchange.getLocalAddress(), aHttpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod()), aHttpExchange.getRequestURI().getPath(), theCredentials, HttpRestServerImpl.this.getRealm());
                if (theBasicAuthResponse != BasicAuthResponse.BASIC_AUTH_SUCCESS) {
                    return HttpRestServerImpl.this.toBasicAuthRequired(aHttpExchange);
                }
                return new Authenticator.Success(new HttpPrincipal(HttpRestServerImpl.ANONYMOUS, HttpRestServerImpl.this.getRealm()));
            }
            int theMarker = theAuthHeader.indexOf(32);
            if (theMarker == -1 || !theAuthHeader.substring(0, theMarker).equals(AuthType.BASIC.getName())) {
                return HttpRestServerImpl.this.toBasicAuthFailure(aHttpExchange);
            }
            byte[] theCredentialChars = Base64.getDecoder().decode(theAuthHeader.substring(theMarker + 1));
            String theCredentialsText = new String(theCredentialChars);
            theMarker = theCredentialsText.indexOf(58);
            theCredentials = new BasicAuthCredentialsImpl(theCredentialsText.substring(0, theMarker), theCredentialsText.substring(theMarker + 1));
            BasicAuthResponse theBasicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(aHttpExchange.getLocalAddress(), aHttpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod()), aHttpExchange.getRequestURI().getPath(), (BasicAuthCredentials)theCredentials, HttpRestServerImpl.this.getRealm());
            if (theBasicAuthResponse == null) {
                throw new NullPointerException("Your <HttpBasicAuthenticator> instance must return an element of type <BasicAuthResponse> and not null.");
            }
            switch (theBasicAuthResponse) {
                case BASIC_AUTH_SUCCESS: {
                    return HttpRestServerImpl.this.toBasicOutSuccess(theCredentials.getIdentity());
                }
                case BASIC_AUTH_REQUIRED: {
                    return HttpRestServerImpl.this.toBasicAuthRequired(aHttpExchange);
                }
                case BASIC_AUTH_FAILURE: {
                    return HttpRestServerImpl.this.toBasicAuthFailure(aHttpExchange);
                }
            }
            throw new BugException("Missing case statement for <" + theBasicAuthResponse + "> in implementation!");
        }
    }
}

