/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.runtime.PropertyBuilder;
import org.refcodes.runtime.PropertyBuilderImpl;

public class PropertyBuilderTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String[] KEYS = new String[]{"my___System--Property__", "_My-System-Property", "mySystemProperty__", "mySystemProperty", "MY_SYSTEM_PROPERTY", "my_system_property", "My_System_Property", "My-System-Property", "my/System/Property"};
    private static final String NORMALIZED_KEY = "my_system_property";
    private static final String ENVIRONMENT_VARIABLE = "MY_SYSTEM_PROPERTY";
    private static final String SYSTEM_PROPERTY = "my.system.property";
    private static final String PATH = "/my/system/property";

    @Test
    public void testNormalizeProperty() {
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(PropertyBuilderImpl.toNormalized((String)eKey, (char)Delimiter.SNAKE_CASE.getChar()));
            }
            Assertions.assertEquals((Object)NORMALIZED_KEY, (Object)PropertyBuilderImpl.toNormalized((String)eKey, (char)Delimiter.SNAKE_CASE.getChar()));
        }
    }

    @Test
    public void testEnvironmentVariable() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(theBuilder.toEnvironmentVariable(eKey));
            }
            Assertions.assertEquals((Object)ENVIRONMENT_VARIABLE, (Object)theBuilder.toEnvironmentVariable(eKey));
        }
    }

    @Test
    public void testEnvironmentVariableWithState() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(((PropertyBuilder)theBuilder.withKey((Object)eKey)).toEnvironmentVariable());
            }
            Assertions.assertEquals((Object)ENVIRONMENT_VARIABLE, (Object)((PropertyBuilder)theBuilder.withKey((Object)eKey)).toEnvironmentVariable());
        }
    }

    @Test
    public void testSystemProperty() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(theBuilder.toSystemProperty(eKey));
            }
            Assertions.assertEquals((Object)SYSTEM_PROPERTY, (Object)theBuilder.toSystemProperty(eKey));
        }
    }

    @Test
    public void testSystemPropertyWithState() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(((PropertyBuilder)theBuilder.withKey((Object)eKey)).toSystemProperty());
            }
            Assertions.assertEquals((Object)SYSTEM_PROPERTY, (Object)((PropertyBuilder)theBuilder.withKey((Object)eKey)).toSystemProperty());
        }
    }

    @Test
    public void testPath() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(theBuilder.toPath(eKey));
            }
            Assertions.assertEquals((Object)PATH, (Object)theBuilder.toPath(eKey));
        }
    }

    @Test
    public void testPathWithState() {
        PropertyBuilderImpl theBuilder = new PropertyBuilderImpl();
        for (String eKey : KEYS) {
            if (IS_LOG_TESTS) {
                System.out.println(((PropertyBuilder)theBuilder.withKey((Object)eKey)).toPath());
            }
            Assertions.assertEquals((Object)PATH, (Object)((PropertyBuilder)theBuilder.withKey((Object)eKey)).toPath());
        }
    }
}

