/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.util.Arrays;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentProperty;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;

public final class EnvironmentUtility {
    private EnvironmentUtility() {
    }

    public static String toAbsoluteUserHomePath(String aPath) throws IllegalStateException {
        File theConfigFile = new File(aPath);
        if (theConfigFile.exists()) {
            return theConfigFile.getAbsolutePath();
        }
        try {
            String theUserHome = EnvironmentProperty.USER_HOME.getValue();
            if (theUserHome == null || theUserHome.length() == 0) {
                theUserHome = SystemProperty.USER_HOME.getValue();
            }
            return EnvironmentUtility.toAbsolutePathFromEnvironment(aPath, theUserHome);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(ExceptionUtility.toMessage((Throwable)e), e);
        }
    }

    public static String toAbsolutePathFromEnvironment(String aPath, String ... aEnvHomePropertyNames) throws IllegalArgumentException {
        if (aPath == null || aPath.length() == 0 || aPath.charAt(0) == Delimiter.PATH.getChar() || aPath.length() > 1 && aPath.charAt(1) == ':') {
            return aPath;
        }
        File theConfigFile = new File(aPath);
        if (theConfigFile.exists()) {
            return theConfigFile.getAbsolutePath();
        }
        String eHomePath = null;
        for (int i = 0; i < aEnvHomePropertyNames.length; ++i) {
            eHomePath = System.getenv(aEnvHomePropertyNames[i]);
            if (eHomePath == null || eHomePath.length() <= 0) continue;
            String thePath = eHomePath + Delimiter.PATH.getChar() + aPath;
            return thePath;
        }
        throw new IllegalArgumentException("A relative path \"" + aPath + "\" was provided though the system environment variable(s) " + Arrays.asList(aEnvHomePropertyNames).toString() + " is not set, unable to create an absolute path. Either set the system environment variable or specify an absolute path.");
    }

    public static String toPlatformSpecificPath(String aPath) {
        String theFileSeparator = SystemProperty.FILE_SEPARATOR.getValue();
        if (theFileSeparator == null || theFileSeparator.length() == 1) {
            // empty if block
        }
        return aPath;
    }
}

