/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jline.TerminalFactory;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.EnvironmentProperty;
import org.refcodes.data.Literal;
import org.refcodes.data.SystemProperty;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.Terminal;

public final class SystemUtility {
    private SystemUtility() {
    }

    public static String getLineBreak() {
        String theLineBreak = SystemProperty.CONSOLE_LINE_BREAK.getValue();
        if (!(theLineBreak != null && theLineBreak.length() != 0 || (theLineBreak = EnvironmentProperty.CONSOLE_LINE_BREAK.getValue()) != null && theLineBreak.length() != 0)) {
            theLineBreak = System.lineSeparator();
        }
        if (theLineBreak == null || theLineBreak.length() == 0) {
            theLineBreak = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? "\r\n" : "\n";
        }
        return theLineBreak;
    }

    public static boolean isUseLineBreak(int aRowWidth) {
        boolean isLineBreak = true;
        if ((Shell.toShell() == Shell.WIN_CMD || OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && Terminal.toTerminal() == Terminal.CYGWIN && SystemUtility.getUname() != null) && aRowWidth == SystemUtility.getTerminalWidth()) {
            isLineBreak = false;
        }
        return isLineBreak;
    }

    public static String toLineBreak(int aRowWidth) {
        if (SystemUtility.isUseLineBreak(aRowWidth)) {
            return SystemUtility.getLineBreak();
        }
        return "";
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String theName = EnvironmentProperty.COMPUTERNAME.getValue();
            if (theName != null && theName.length() > 0) {
                return theName;
            }
            return Literal.LOCALHOST.getName();
        }
    }

    public static String getUname() {
        try {
            return SystemUtility.exec("uname -a");
        }
        catch (IOException | InterruptedException ignore) {
            return null;
        }
    }

    public static int getTerminalWidth() {
        String theResult;
        int theTerminalWidth = -1;
        try {
            Thread theDummyThread = new Thread();
            Runtime.getRuntime().addShutdownHook(theDummyThread);
            Runtime.getRuntime().removeShutdownHook(theDummyThread);
            theTerminalWidth = TerminalFactory.get().getWidth();
        }
        catch (Exception theDummyThread) {
            // empty catch block
        }
        if (theTerminalWidth <= 1 && (theResult = EnvironmentProperty.TERMINAL_WIDTH.getValue()) != null) {
            try {
                theTerminalWidth = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theTerminalWidth <= 1) {
            theTerminalWidth = -1;
        }
        return theTerminalWidth;
    }

    public static int getTerminalHeight() {
        String theResult;
        int theTerminalHeight = -1;
        try {
            theTerminalHeight = TerminalFactory.get().getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (theTerminalHeight <= 1 && (theResult = EnvironmentProperty.TERMINAL_HEIGHT.getValue()) != null) {
            try {
                theTerminalHeight = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theTerminalHeight <= 1) {
            theTerminalHeight = -1;
        }
        return theTerminalHeight;
    }

    public static int toConsoleWidth() {
        int theConsoleWidth = SystemUtility.getTerminalWidth();
        int theWidth = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_WIDTH, EnvironmentProperty.CONSOLE_WIDTH);
        if (theResult != null) {
            try {
                theWidth = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theWidth <= 1 && ((theWidth = theConsoleWidth) < ConsoleDimension.MIN_WIDTH.getValue() || theWidth <= 1)) {
            theWidth = ConsoleDimension.MIN_WIDTH.getValue();
        }
        return theWidth;
    }

    public static int toConsoleHeight() {
        int theConsoleHeight = SystemUtility.getTerminalHeight();
        int theHeight = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_HEIGHT, EnvironmentProperty.CONSOLE_HEIGHT);
        if (theResult != null) {
            try {
                theHeight = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theHeight <= 1 && ((theHeight = theConsoleHeight) < ConsoleDimension.MIN_HEIGHT.getValue() || theHeight <= 1)) {
            theHeight = ConsoleDimension.MIN_HEIGHT.getValue();
        }
        return theHeight;
    }

    public static String toPropertyValue(String aDefaultValue, SystemProperty aSystemProperty, EnvironmentProperty ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentProperty eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() <= 0) continue;
                return theValue;
            }
        }
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        return aDefaultValue;
    }

    public static String toPropertyValue(SystemProperty aSystemProperty, EnvironmentProperty ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentProperty eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() <= 0) continue;
                return theValue;
            }
        }
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        return null;
    }

    public static String exec(String aCommand) throws IOException, InterruptedException {
        String line;
        StringBuilder theBuilder = new StringBuilder();
        Runtime theRuntime = Runtime.getRuntime();
        Process theProcess = theRuntime.exec(aCommand);
        theProcess.waitFor();
        BufferedReader theReader = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
        while ((line = theReader.readLine()) != null) {
            theBuilder.append(line);
        }
        theReader.close();
        return theBuilder.toString();
    }

    public static boolean isAnsiTerminal() {
        if (SystemUtility.isCygwin()) {
            return true;
        }
        jline.Terminal theTerminal = TerminalFactory.get();
        return theTerminal.isAnsiSupported();
    }

    public static boolean toAnsiConsole() {
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_ANSI, EnvironmentProperty.CONSOLE_ANSI);
        if (theResult != null) {
            try {
                return NumericalUtility.toBoolean((String)theResult.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return SystemUtility.isAnsiTerminal();
    }

    public static File getTempDir() {
        String tempDir = SystemProperty.TEMP_DIR.getValue();
        File theTempDir = new File(tempDir);
        return theTempDir;
    }

    public static String getSystemEncoding() {
        OutputStreamWriter theOutWriter = new OutputStreamWriter(System.out);
        return theOutWriter.getEncoding();
    }

    public static Map<String, String> toSystemInfo() {
        HashMap<String, String> theInfo = new HashMap<String, String>();
        theInfo.put("computerName", SystemUtility.getComputerName() + SystemUtility.getLineBreak());
        theInfo.put("operatingSystem", (Object)((Object)OperatingSystem.toOperatingSystem()) + SystemUtility.getLineBreak());
        theInfo.put("shell", (Object)((Object)Shell.toShell()) + SystemUtility.getLineBreak());
        theInfo.put("terminal", (Object)((Object)Terminal.toTerminal()) + SystemUtility.getLineBreak());
        theInfo.put("terminalWidth", SystemUtility.getTerminalWidth() + SystemUtility.getLineBreak());
        theInfo.put("terminalHeight", SystemUtility.getTerminalHeight() + SystemUtility.getLineBreak());
        theInfo.put("enforceConsoleWidth", SystemUtility.toConsoleWidth() + SystemUtility.getLineBreak());
        theInfo.put("enforceConsleHeight", SystemUtility.toConsoleHeight() + SystemUtility.getLineBreak());
        theInfo.put("consoleWidthLineBreak", SystemUtility.isUseLineBreak(SystemUtility.getTerminalWidth()) + SystemUtility.getLineBreak());
        theInfo.put("ansiSupport", SystemUtility.isAnsiTerminal() + SystemUtility.getLineBreak());
        theInfo.put("enforceAnsiUsage", SystemUtility.toAnsiConsole() + SystemUtility.getLineBreak());
        theInfo.put("systemEncoding", SystemUtility.getSystemEncoding() + SystemUtility.getLineBreak());
        theInfo.put("systemLineBreak", SystemUtility.getLineBreak().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r") + SystemUtility.getLineBreak());
        theInfo.put("tempDir", SystemUtility.getTempDir() + SystemUtility.getLineBreak());
        theInfo.put("uname", SystemUtility.getUname() + SystemUtility.getLineBreak());
        return theInfo;
    }

    public static String toPrettySystemInfo() {
        StringBuffer theBuffer = new StringBuffer();
        Map<String, String> theInfo = SystemUtility.toSystemInfo();
        int maxLength = -1;
        for (String eKey : theInfo.keySet()) {
            if (eKey.length() <= maxLength) continue;
            maxLength = eKey.length();
        }
        Iterator<String> iterator = theInfo.keySet().iterator();
        while (iterator.hasNext()) {
            String eKey;
            String tmpKey = eKey = iterator.next();
            while (tmpKey.length() < maxLength) {
                tmpKey = tmpKey + " ";
            }
            theBuffer.append(tmpKey + " := " + theInfo.get(eKey));
        }
        return theBuffer.toString();
    }

    static boolean isCygwin() {
        String theUname;
        if (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && (theUname = SystemUtility.getUname()) != null && theUname.toLowerCase().indexOf("cygwin") != -1) {
            String thePwd = System.getenv("PWD");
            return thePwd != null && thePwd.length() != 0;
        }
        return false;
    }
}

