/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.refcodes.mixin.ResultAccessor;

public class ProcessResult
implements ResultAccessor<String> {
    private String _result;

    public ProcessResult(Process aProcess) throws IOException {
        try {
            aProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._result = this.toResult(aProcess);
    }

    public ProcessResult(Process aProcess, int aTimeOutMillis) throws InterruptedException, IOException {
        if (aTimeOutMillis != -1) {
            aProcess.waitFor(aTimeOutMillis, TimeUnit.MILLISECONDS);
            if (aProcess.isAlive()) {
                try {
                    aProcess.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new InterruptedException("Killed process <" + aProcess.toString() + ">!");
            }
        } else {
            aProcess.waitFor();
        }
        this._result = this.toResult(aProcess);
    }

    public String getResult() {
        return this._result;
    }

    public String toString() {
        return this._result;
    }

    private String toResult(Process aProcess) throws IOException {
        try {
            StringBuilder theOutBuilder = new StringBuilder();
            try (BufferedReader theOutReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));){
                String eLine;
                while ((eLine = theOutReader.readLine()) != null) {
                    theOutBuilder.append(eLine);
                }
            }
            return theOutBuilder.toString();
        }
        catch (IOException e) {
            StringBuilder theErrBuilder = new StringBuilder();
            try {
                Throwable throwable;
                BufferedReader theErrReader;
                block17: {
                    theErrReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
                    throwable = null;
                    try {
                        String eErr;
                        if (theErrReader == null) break block17;
                        while ((eErr = theErrReader.readLine()) != null) {
                            theErrBuilder.append(eErr);
                        }
                        theErrReader.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ProcessResult.$closeResource(throwable, theErrReader);
                            throw throwable3;
                        }
                    }
                }
                ProcessResult.$closeResource(throwable, theErrReader);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (theErrBuilder.length() != 0) {
                throw new IOException(theErrBuilder.toString(), e);
            }
            throw e;
        }
    }
}

