// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

/**
 * Provides an accessor for a {@link Column} property.
 *
 * @param <T> the generic type
 */
public interface ColumnAccessor<T> {

	/**
	 * Retrieves the {@link Column} property.
	 * 
	 * @return The {@link Column} being stored by this property.
	 */
	Column<T> getColumn();

	/**
	 * Provides a mutator for a {@link Column} property.
	 *
	 * @param <T> the generic type
	 */
	public interface ColumnMutator<T> {

		/**
		 * Sets the {@link Column} property.
		 * 
		 * @param aColumn The {@link Column} to be stored by this property.
		 */
		void setColumn( Column<T> aColumn );
	}

	/**
	 * Provides a {@link Column} property.
	 *
	 * @param <T> the generic type
	 */
	public interface ColumnProperty<T> extends ColumnAccessor<T>, ColumnMutator<T> {}
}
