// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

import org.refcodes.tabular.TabularException.TabularColumnException.TabularColumnValueException;

/**
 * Thrown in case a value was found in the e.g. in a {@link Record} of the wrong
 * type than specified by a provided {@link Column} (of for example a
 * {@link Header}).
 */
public class ColumnMismatchException extends TabularColumnValueException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, String aMessage, String aErrorCode ) {
		super( aColumn, aValue, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aColumn, aValue, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param message the message
	 * @param cause the cause
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, String message, Throwable cause ) {
		super( aColumn, aValue, message, cause );
	}

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param message the message
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, String message ) {
		super( aColumn, aValue, message );
	}

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, Throwable aCause, String aErrorCode ) {
		super( aColumn, aValue, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new column mismatch exception.
	 *
	 * @param aColumn the column
	 * @param aValue the value
	 * @param cause the cause
	 */
	public ColumnMismatchException( Column<?> aColumn, Object aValue, Throwable cause ) {
		super( aColumn, aValue, cause );
	}

}
