// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

/**
 * Implementation of the {@link Fields} interface being {@link Cloneable}.
 *
 * @param <T> The type of the value of the fields.
 */
public class FieldsImpl<T> extends FieldImpl<T[]> implements Fields<T>, Cloneable {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link Fields} instance with an array of values.
	 * 
	 * @param aKey The key of the {@link Field}.
	 * @param aValue The value of the {@link Field}.
	 * 
	 */
	public FieldsImpl( String aKey, T[] aValue ) {
		super( aKey, aValue );
	}
}
