// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.tabular;

import org.refcodes.textual.ColumnSetupMetrics;

/**
 * Enriches a {@link Column} with rendering metrics (as of the
 * {@link ColumnSetupMetrics}) mostly for text-based output such as for
 * generating output for a terminal / console.
 * 
 * @param <T> The type managed by the {@link Column}.
 */
public interface FormattedColumn<T> extends Column<T>, ColumnSetupMetrics {

}
