package org.refcodes.tabular;

/**
 * The Class FormattedHeaderImpl.
 *
 * @param <T> the generic type
 */
public class FormattedHeaderImpl<T> extends AbstractHeader<T, FormattedColumn<? extends T>> implements FormattedHeader<T> {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _resetEscapeCode = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new formatted header impl.
	 */
	public FormattedHeaderImpl() {
		super();
	}

	/**
	 * Instantiates a new formatted header impl.
	 *
	 * @param aHeader the header
	 */
	@SuppressWarnings("unchecked")
	public FormattedHeaderImpl( FormattedColumn<? extends T>... aHeader ) {
		super( aHeader );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getResetEscapeCode() {
		return _resetEscapeCode;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setResetEscapeCode( String aEscapeCode ) {
		_resetEscapeCode = aEscapeCode;
	}
}