// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.tabular;

/**
 * Extends the {@link Records} with means to monitor the state of file based
 * implementations. Reading {@link Record} instances may cause problems but no
 * abortion of an operation (if desired), the statistics of the problems may be
 * reported by an implementation of this interface.
 *
 * @param <T> The type managed by the {@link Records}.
 */
public interface InputStreamRecords<T> extends Records<T>, HeaderAccessor<T> {

	/**
	 * The number of erroneous records which were not read by the
	 * {@link InputStreamRecords}.
	 *
	 * @return the erroneous record count
	 */
	long getErroneousRecordCount();
}
