// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * The tabular package provides a frame to handle tables of data, often
 * occurring when logging or when working with CSV files. As of the anatomy of a
 * DB table or spread sheet or a CSV file (or a log file), the table frame
 * provides the base types:
 * 
 * <ul>
 * <li>@link org.refcodes.tabular.Column}</li>
 * <li>{@link org.refcodes.tabular.Header}</li>
 * <li>{@link org.refcodes.tabular.Header}</li>
 * <li>{@link org.refcodes.tabular.Row}</li>
 * <li>{@link org.refcodes.tabular.Rows}</li>
 * <li>{@link org.refcodes.tabular.Record}</li>
 * <li>{@link org.refcodes.tabular.Records}</li>
 * </ul>
 *
 * <h2>{@link org.refcodes.tabular.Column}:</h2>
 *
 * Similar to a column definition for a DB or a spread sheet (or, with
 * reservations, a CSV file), a {@link org.refcodes.tabular.Column} describes
 * properties such as name (key) and type of elements related to that
 * {@link org.refcodes.tabular.Column} (e.g. the according elements of the
 * {@link org.refcodes.tabular.Row} lines).
 *
 * <h2>{@link org.refcodes.tabular.Header}:</h2>
 *
 * A list of {@link org.refcodes.tabular.Column} instances, for example
 * describing the elements of a CSV file (visually speaking the of the CSV
 * file's header line), is represented by the
 * {@link org.refcodes.tabular.Header}. The {@link org.refcodes.tabular.Header}
 * preserves an order for a list of {@link org.refcodes.tabular.Column}
 * instances. A {@link org.refcodes.tabular.Header} provides the semantics for
 * related {@link org.refcodes.tabular.Row} instances.
 *
 * <h2>{@link org.refcodes.tabular.Header}:</h2>
 *
 * In case no order of the {@link org.refcodes.tabular.Column} instances is
 * explicitly required (similar to a DB table or a spread sheet, in contrast to
 * a CSV file) then {@link org.refcodes.tabular.Column} instances are grouped by
 * a {@link org.refcodes.tabular.Header} set.
 * <p>
 * {@link org.refcodes.tabular.Header} provide additional semantics to the
 * {@link org.refcodes.tabular.Field} instances stored in a
 * {@link org.refcodes.tabular.Record}.
 *
 * <h2>{@link org.refcodes.tabular.Row}:</h2>
 *
 * A {@link org.refcodes.tabular.Row} holds multiple data elements loosely
 * coupled to a {@link org.refcodes.tabular.Header}. As a
 * {@link org.refcodes.tabular.Row} just contains a list of data elements with
 * no keys (names) directly associated to the elements, a
 * {@link org.refcodes.tabular.Header} with the according list of key (name) and
 * type definitions is required to give a {@link org.refcodes.tabular.Row} its
 * semantics.
 * <p>
 * In terms of a CSV file, a {@link org.refcodes.tabular.Row} represents a
 * single line of comma separated values. The
 * {@link org.refcodes.tabular.Header} stands for the header line (top line) of
 * the CSV file. The semantics for the content of a
 * {@link org.refcodes.tabular.Row} is provided by the according
 * {@link org.refcodes.tabular.Header}.
 * <p>
 * Many {@link org.refcodes.tabular.Row} instances are contained in a
 * {@link org.refcodes.tabular.Rows} instance which in turn requires a single
 * {@link org.refcodes.tabular.Header} to give all the therein contained
 * {@link org.refcodes.tabular.Row} instances their semantics (in terms of key
 * (name) and type information).
 * <p>
 * In contrast to a {@link org.refcodes.tabular.Row}, a
 * {@link org.refcodes.tabular.Record} relates an element field with a key
 * (name), called {@link org.refcodes.tabular.Field}.
 * <p>
 * In contrast to a {@link org.refcodes.tabular.Record}, a
 * {@link org.refcodes.tabular.Row} does not relate a key (name) to its values.
 * To do this, a {@link org.refcodes.tabular.Header} is required. Similar to a
 * {@link org.refcodes.tabular.Record}, a {@link org.refcodes.tabular.Row} makes
 * use of {@link org.refcodes.tabular.Column} instances (provided by a
 * {@link org.refcodes.tabular.Header} instance) to give the fields additional
 * semantics.
 *
 * <h2>{@link org.refcodes.tabular.Rows}:</h2>
 *
 * A bunch of {@link org.refcodes.tabular.Row} instances is represented by a
 * {@link org.refcodes.tabular.Rows} instance. As of efficiency reasons, a
 * {@link org.refcodes.tabular.Rows} instance can be iterated through, returning
 * a single {@link org.refcodes.tabular.Row} within each iteration. This
 * approach is making it possible to query a DB in the background and just hold
 * the {@link org.refcodes.tabular.Row} instances being served next in the
 * {@link org.refcodes.tabular.Rows} instance (in memory).
 * <p>
 * The way how {@link org.refcodes.tabular.Rows} instances manage their related
 * {@link org.refcodes.tabular.Row} instances is implementation specific, a
 * plain java implementation might use some kind of collection for storing the
 * {@link org.refcodes.tabular.Row} instances (this can get memory intensive and
 * not applicable when working with big data). A DB implementation might
 * retrieve the {@link org.refcodes.tabular.Row} instances in blocks one by one,
 * one after the other, by querying the DB accordingly (in terms of "next"
 * result sets).
 *
 * <h2>{@link org.refcodes.tabular.Record}:</h2>
 *
 * A {@link org.refcodes.tabular.Record} is a {@link java.util.Map} containing
 * {@link org.refcodes.tabular.Field} data structures with support for
 * {@link org.refcodes.tabular.Column} definitions. The
 * {@link org.refcodes.tabular.Field} instances can be managed with the
 * functionality provided by a {@link org.refcodes.tabular.Column}.
 * <p>
 * A value can be retrieved from a {@link org.refcodes.tabular.Record} by
 * providing an according {@link org.refcodes.tabular.Column} definition, which
 * verifies the value type. Also values can be converted to and from the
 * appropriate interchange and string formats by the according
 * {@link org.refcodes.tabular.Column} instances.
 * <p>
 * In contrast to a {@link org.refcodes.tabular.Row}, a
 * {@link org.refcodes.tabular.Record} relates the key (name) to its values.
 * Similar to a {@link org.refcodes.tabular.Row}, a
 * {@link org.refcodes.tabular.Record} makes use of
 * {@link org.refcodes.tabular.Column} instances (for example as provided by a
 * {@link org.refcodes.tabular.Header} or a {@link org.refcodes.tabular.Header}
 * instance) to give the fields additional semantics.
 *
 * <h2>{@link org.refcodes.tabular.Records}:</h2>
 *
 * A bunch of {@link org.refcodes.tabular.Record} instances is represented by a
 * {@link org.refcodes.tabular.Records} instance. As of efficiency reasons, a
 * {@link org.refcodes.tabular.Records} instance can be iterated through,
 * returning a single {@link org.refcodes.tabular.Record} within each iteration.
 * This approach is making it possible to query a DB in the background and just
 * hold the {@link org.refcodes.tabular.Record} instances being served next in
 * the {@link org.refcodes.tabular.Records} instance (in memory).
 * <p>
 * The way how {@link org.refcodes.tabular.Records} instances manage their
 * related {@link org.refcodes.tabular.Record} instances is implementation
 * specific, a plain java implementation might use some kind of collection for
 * storing the {@link org.refcodes.tabular.Record} instances (this can get
 * memory intensive and not applicable when working with big data). A DB
 * implementation might retrieve the {@link org.refcodes.tabular.Record}
 * instances in blocks one by one, one after the other, by querying the DB
 * accordingly (in terms of "next" result sets).
 */
package org.refcodes.tabular;