// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.time;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * @author steiner
 *
 */
public class TimeUnitTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static long ONE_YEAR_IN_SECONDS = 31536000;
	private static long FOUR_DAYS_IN_MINUTES = 5760;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testTimeConversion() {
		float theSeconds = TimeUnit.toTimeUnit( TimeUnit.YEAR, 1, TimeUnit.SECOND );
		assertEquals( ONE_YEAR_IN_SECONDS, theSeconds, 0 );

		float theYear = TimeUnit.toTimeUnit( TimeUnit.SECOND, ONE_YEAR_IN_SECONDS, TimeUnit.YEAR );
		assertEquals( 1, theYear, 0 );

		float theMinutes = TimeUnit.toTimeUnit( TimeUnit.DAY, 4, TimeUnit.MINUTE );
		assertEquals( FOUR_DAYS_IN_MINUTES, theMinutes, 0 );

		float theDays = TimeUnit.toTimeUnit( TimeUnit.MINUTE, FOUR_DAYS_IN_MINUTES, TimeUnit.DAY );
		assertEquals( 4, theDays, 0 );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
